/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.web;

import cc.lechun.framework.common.utils.sign.MD5;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestDetail {
    private static final Logger log = LoggerFactory.getLogger(RequestDetail.class);

    public static String getRequestString(HttpServletRequest request, String key, String defaultValue) {
        String value = request.getParameter(key);
        return value != null ? value : defaultValue;
    }

    public static int getRequestInt(HttpServletRequest request, String key, int defaultValue) {
        String value = request.getParameter(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public static long getRequestLong(HttpServletRequest request, String key, long defaultValue) {
        String value = request.getParameter(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public static double getRequestDouble(HttpServletRequest request, String key, double defaultValue) {
        String value = request.getParameter(key);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    public static HttpServletRequest getCurrentRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return attributes.getRequest();
    }

    public static HttpServletResponse getCurrentResponse() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return attributes.getResponse();
    }

    public static String getDomain(HttpServletRequest request) {
        try {
            String server = request.getServerName();
            int start = server.indexOf(".") + 1;
            String domain = server.substring(start);
            return domain;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static String getFullUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        if (StringUtils.isNotEmpty((CharSequence)request.getQueryString())) {
            url = String.format("%s?%s", url, request.getQueryString());
        }
        return url;
    }

    public static String getFullUri(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (StringUtils.isNotEmpty((CharSequence)request.getQueryString())) {
            url = url + "?" + request.getQueryString();
        }
        return url;
    }

    public static String getPageDomain(HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        if (StringUtils.isNotEmpty((CharSequence)origin)) {
            origin = origin.split("//")[1];
            origin = origin.split("/")[0];
        } else {
            origin = request.getHeader("Referer");
            if (StringUtils.isNotEmpty((CharSequence)origin)) {
                origin = origin.split("//")[1];
                origin = origin.split("/")[0];
            }
        }
        return origin;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return request.getHeader("accept") != null && request.getHeader("accept").indexOf("application/json") != -1;
    }

    public static String md5MallSign(HttpServletRequest request, String key) {
        Map map = request.getParameterMap();
        TreeSet set = new TreeSet(map.keySet());
        set.remove("app_type");
        set.remove("user_type");
        set.remove("device_id");
        set.remove("location");
        set.remove("language");
        set.remove("version_code");
        set.remove("user_agent");
        set.remove("app_platform");
        set.remove("call_id");
        set.remove("ticket");
        set.remove("sign");
        set.remove("sign_method");
        set.remove("callback");
        set.remove("fresh");
        set.remove("_");
        set.remove("channel_id");
        set.remove("ip_addr");
        set.remove("url");
        set.remove("frompage");
        set.remove("USER_IMG");
        set.remove("USER_FILE");
        set.remove("callbackType");
        set.remove("testId");
        Iterator i = set.iterator();
        String p = "";
        while (i.hasNext()) {
            String i0 = i.next().toString();
            p = p + i0.trim() + ":" + RequestDetail.getRequestString(request, i0, "").trim().replace(" ", "") + ",";
        }
        if (p.lastIndexOf(",") > 0) {
            p = p.substring(0, p.length() - 1);
        }
        return MD5.sign(p + "_" + key, "").toLowerCase();
    }

    public static Map<String, String> getParameterStringMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String name = "";
        String value = "";
        for (Map.Entry entry : properties.entrySet()) {
            name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (null == values) {
                value = "";
            } else if (values.length > 1) {
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = values[0];
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }
}

