package cc.lechun.framework.common.enums.cashticket;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/2/28
 * Description: 1福利社 2套装 3促销 4活动 5平台  6单品产品
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CashRuleTypeEnum {
    //fulishe(1, "福利社"),
    taozhuang(2, "套装"),
    cuxiao(3, "促销"),
    //huodong(4, "活动"),
    pingtai(5, "平台"),
    danpin(6, "单品");

    private int value;
    private String name;


    public static String getName(int value) {
        CashRuleTypeEnum[] ls = CashRuleTypeEnum.values();
        for (CashRuleTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    /**
     * 获取列表
     */
    public static List<CashRuleTypeEnum> getList() {
        return Arrays.asList(CashRuleTypeEnum.values());
    }

    CashRuleTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
