package cc.lechun.framework.common.utils.cache;

import com.google.code.ssm.CacheFactory;
import com.google.code.ssm.Settings;
import com.google.code.ssm.config.DefaultAddressProvider;
import com.google.code.ssm.providers.CacheConfiguration;
import com.google.code.ssm.providers.xmemcached.MemcacheClientFactoryImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

/**
 * Created by wangxs on 2017/12/18
 * Description: memcache配置类
 */
@Configuration
@ImportResource("classpath*:simplesm-context.xml")
@RefreshScope
public class MemcacheServiceConfig {

    @Value("${memcached.servers:}")
    private String memcached_servers;

    /**
     * 缓存配置
     *
     * @return
     */
    @Bean
    public CacheFactory defaultMemcachedClient() {
        CacheFactory cacheFactory = new CacheFactory();
        cacheFactory.setCacheClientFactory(memcacheClientFactoryImpl());
        cacheFactory.setAddressProvider(defaultAddressProvider());
        cacheFactory.setConfiguration(cacheConfiguration());
        return cacheFactory;
    }

    @Bean
    public MemcacheClientFactoryImpl memcacheClientFactoryImpl() {
        MemcacheClientFactoryImpl memcacheClientFactoryImpl = new MemcacheClientFactoryImpl();
        return memcacheClientFactoryImpl;
    }

    @Bean
    public DefaultAddressProvider defaultAddressProvider() {
        DefaultAddressProvider defaultAddressProvider = new DefaultAddressProvider();
        defaultAddressProvider.setAddress(memcached_servers);
        return defaultAddressProvider;
    }


    @Bean
    public CacheConfiguration cacheConfiguration() {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setConsistentHashing(true);
        return cacheConfiguration;
    }

    @Bean
    public Settings settings() {
        Settings settings = new Settings();
        settings.setOrder(10);
        return settings;
    }
    //缓存配置结束
}
