package cc.lechun.framework.common.enums.cashticket;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/1/23
 * Description:优惠劵的状态  合在一起
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CashStatusEnum {
    weijihuo(0, "未激活"),
    yijihuo(1, "未使用"),
    yishiyong(2, "已使用"),
    guoqi(3, "已过期"),
    bufen(4, "部分使用"),
    jinyong(5, "禁用");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<CashStatusEnum> getList() {
        return Arrays.asList(CashStatusEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(Integer value) {
        if(value==null){
            return "";
        }
        CashStatusEnum[] ls = CashStatusEnum.values();
        for (CashStatusEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    CashStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
