package cc.lechun.framework.common.enums.trade;

import java.util.Arrays;
import java.util.List;

/**
 * Created by liqun on 2018/1/12.
 */
public enum ChannelEnum {
    WECHAT(1, "微信商城"),
    PC(2, "PC网上商城"),
    ANDROID(3, "移动端Android"),
    IOS(4,"移动端IOS"),
    ERP(5,"后台ERP订单"),
    WAP(213,"Wap商城"),
    MINI(86,"小程序"),
    SPEEDUP(128,"极速达");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<ChannelEnum> getList() {
        return Arrays.asList(ChannelEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        ChannelEnum[] ls = ChannelEnum.values();
        for (ChannelEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        ChannelEnum[] ls = ChannelEnum.values();
        for (ChannelEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    ChannelEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "ChannelEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
