package cc.lechun.framework.common.utils.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.codehaus.jackson.util.DefaultPrettyPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.*;


public class JsonUtils {

    private final static Logger log = LoggerFactory.getLogger(JsonUtils.class);

    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Set<String> getObjectFields(JsonNode node) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        if (node != null && node.isObject()) {
            Iterator<String> iter = node.getFieldNames();
            while (iter.hasNext())
                fields.add(iter.next());
        }
        return fields;
    }

    public static Object readValue(JsonParser jp, final Type type) throws IOException {
        return OBJECT_MAPPER.readValue(jp, new TypeReference<Object>() {
            @Override
            public Type getType() {
                return type;
            }
        });
    }

    public static void writeValue(JsonGenerator jg, Object o, Boolean human) throws IOException {

        if (human != null && human)
            jg.setPrettyPrinter(new DefaultPrettyPrinter());

        OBJECT_MAPPER.writeValue(jg, o);
    }

    public static String toJson(Object o, boolean human) {
        StringWriter w = new StringWriter();
        JsonGenerator jg = null;
        try {
            jg = JSON_FACTORY.createJsonGenerator(w);
            writeValue(jg, o, human);
            jg.flush();
            return w.toString();
        } catch (IOException e) {
            //throw new IOException("换换json失败",e);
            log.error("转换json失败", e);
        } finally {
            if (jg != null) {
                try {
                    jg.close();
                } catch (IOException ignored) {
                    log.error("", ignored);
                }
            }
        }
        return "";
    }


    public static String toJson(JsonGenerateHandler h, boolean human) throws IOException {
        StringWriter w = new StringWriter();
        JsonGenerator jg = null;
        try {
            jg = JSON_FACTORY.createJsonGenerator(w);
            if (human)
                jg.setPrettyPrinter(new DefaultPrettyPrinter());

            h.generate(jg);
            jg.flush();
            return w.toString();
        } catch (IOException e) {
            throw new IOException("", e);
        } finally {
            if (jg != null) {
                try {
                    jg.close();
                } catch (IOException ignored) {
                    log.error("", ignored);
                }
            }
        }

    }

    @SuppressWarnings("unchecked")
    public static <T> T fromJson(String json, Class<T> type) throws IOException {
        return (T) fromJson(json, (Type) type);
    }

    public static Object fromJson(String json, Type type) throws IOException {
        JsonParser jp = null;
        try {
            try {
                jp = JSON_FACTORY.createJsonParser(json);
                return readValue(jp, type);
            } finally {
                if (jp != null) {
                    try {
                        jp.close();
                    } catch (IOException ignored) {
                        log.error("", ignored);
                    }
                }
            }
        } catch (IOException e) {
            throw new IOException("转换json失败", e);
        }
    }

    public static JsonNode parse(String json) throws IOException {
        return fromJson(json, JsonNode.class);
    }

    public static boolean isValidate(String json) {
        try {
            // TODO: this method is slow
            parse(json);
            return true;
        } catch (Exception e) {
            return false;
        }
    }
    /**
     * 根据JSONArray String获取到List
     * @param <T>
     * @param <T>
     * @param jArrayStr
     * @return
     */
    public static <T> List<T> getListByArray(Class<T> class1, String jArrayStr) {
        List<T> list = new ArrayList();
        JSONArray jsonArray = JSONArray.parseArray(jArrayStr);
        if (jsonArray==null || jsonArray.isEmpty()) {
            return list;//nerver return null
        }
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject) object;
            T t = JSONObject.toJavaObject(jsonObject, class1);
            list.add(t);
        }
        return list;
    }

    public static Map stringToMap(String s) {
        Map m = JSONObject.parseObject(s);
        return m;
    }
}
