package cc.lechun.common.enums.pay;

import java.util.Arrays;
import java.util.List;

/**
 *支付方式
 * 这里的枚举value值必须按照先退款的顺序来，值越小越先退款
 * 在PayOrderService。payRefund会进行排序
 * Description: 枚举
 */
public enum PayTypeEnum {
    WECHAT_PAY(2, "wechatPay"),
    COUPON_PAY(3, "couponPay"),
    ALIPAY_PAY(6, "alipay"),
    BANK_PAY(7,"bankPay"),
    BALANCE_PAY(8,"balancePay"),
    GIFT_PAY(9,"giftPay"),
    OFFLINE_PAY(10,"offLinePay"),
    MILKBANK_PAY(11,"milkBankPay");



    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<PayTypeEnum> getList() {
        return Arrays.asList(PayTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        PayTypeEnum[] ls = PayTypeEnum.values();
        for (PayTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }

    /**
     * 根据value获取汉字名称
     * @param paytype
     * @return
     */
    public static String getPayTypeName(int paytype)
    {
        switch (paytype)
        {
            case 2:
                return "微信支付";
            case 3:
                return "优惠券支付";
            case 6:
                return "支付宝支付";
            case 7:
                return "网银支付";
            case 8:
                return "余额支付";
            case 9:
                return "礼物兑换";
            case 10:
                return "现金支付";
            default:
                return "";
        }
    }

    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        PayTypeEnum[] ls = PayTypeEnum.values();
        for (PayTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    PayTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "PayTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
