package cc.lechun.framework.common.enums.sql;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * @ClassName SqlConstants
 * @Description TODO
 * @Author ThinkPad
 * @Date 2020/2/21 10:48
 * @Version 1.0
 **/
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SqlLikeEnum {
    sqlLike_Pre(1, "前模糊查询"),
    sqlLike_Suffix(2, "后模糊查询"),
    sqlLike_All(3, "全模糊查询");
    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<SqlLikeEnum> getList() {
        return Arrays.asList(SqlLikeEnum.values());
    }
    public static int getValuseSum(){
        int i=0;
        for(SqlLikeEnum v:SqlLikeEnum.values()){
            i+=v.value;
        }
        return i;
    }
    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        SqlLikeEnum[] ls = SqlLikeEnum.values();
        for (SqlLikeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    SqlLikeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
