package cc.lechun.framework.common.utils.file;

import cc.lechun.framework.common.utils.ReflectUtil;
import cc.lechun.framework.common.utils.date.DateFormatUtil;
import cc.lechun.framework.common.vo.ExportVo;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import javax.servlet.ServletOutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class ExportExcelUtil {
    /**
     * 导出Excel
     */
    public static  <T> boolean export(ExportVo<T> exportVO,ServletOutputStream out ) {
        // 创建一个工作薄
        Workbook workbook = null;
        // 判断生成2003版本的excel或 2007版本的excel
        if (exportVO.getFileName().endsWith(".xls")) {
            workbook = new HSSFWorkbook();
        } else if (exportVO.getFileName().endsWith(".xlsx")) {
            workbook = new XSSFWorkbook();
        } else {
            return false;
        }

        // 用给定的表格名称创建一个表格
        Sheet sheet = workbook.createSheet(exportVO.getSheetName());
        // 设置单元格默认宽度
        sheet.setDefaultColumnWidth(15);

        // 设置表头
        Row row = sheet.createRow(0);
        Cell cell = null;

        // 设置表格样式
        CellStyle cellStyle = setCellStyle(workbook);

        String[] headers = exportVO.getHeaders();
        for (int i = 0; i < headers.length; i++) {
            cell = row.createCell(i);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(headers[i]);
        }

        Class<T> cls = null;
        T t = null;

        try {
            // 生成行数据
            int index = 0;
            for (Object params : exportVO.getDataset()) {
                index++;

                row = sheet.createRow(index);
                String[] fieldNames = exportVO.getFieldNames();
                // 如果添加一支类型，在if后添加
                if (params instanceof HashMap) {
                    for (int i = 0; i < fieldNames.length; i++) {
                        Object value = ((HashMap) params).get(fieldNames[i]);
                        //保留三位小数，防止导出表格出现数字过长excle显示错误
                        if(null!=value && value  instanceof Double ) {
                            BigDecimal b = new BigDecimal((Double) value);
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }else if(null!=value && value  instanceof BigDecimal ) {
                            BigDecimal b = new BigDecimal(value.toString());
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }
                        cell = row.createCell(i);

                        cell.setCellValue(handleValue(value, exportVO.getDatePattern()));
                    }
                } else {

                    cls = (Class<T>) params.getClass();
                    for (int i = 0; i < fieldNames.length; i++) {
                        String fieldName = fieldNames[i];
                        String getMethodName = ReflectUtil.getMethodName(fieldName, "get");
                        Method method = cls.getMethod(getMethodName, new Class[]{});
                        Object value = method.invoke(params, new Object[]{});
                        //保留三位小数，防止导出表格出现数字过长excle显示错误
                        if(null!=value && value  instanceof Double ) {
                            BigDecimal b = new BigDecimal((Double) value);
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }else if(null!=value && value  instanceof BigDecimal ) {
                            BigDecimal b = new BigDecimal(value.toString());
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }
                        cell = row.createCell(i);

                        cell.setCellValue(handleValue(value, exportVO.getDatePattern()));

                    }


                }

            }

            // 输出生成的表格
            workbook.write(out);
            IOUtils.closeQuietly(out);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 设置单元格样式
     */
    private static CellStyle setCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setBorderTop(CellStyle.BORDER_THIN);
        cellStyle.setBorderRight(CellStyle.BORDER_THIN);
        cellStyle.setBorderBottom(CellStyle.BORDER_THIN);
        cellStyle.setBorderLeft(CellStyle.BORDER_THIN);
        cellStyle.setAlignment(CellStyle.ALIGN_CENTER);

        // 设置字体
        Font font = setCellFont(workbook);
        cellStyle.setFont(font);
        return cellStyle;
    }

    /**
     * 设置字体
     *
     * @param workbook
     * @return
     * @author 梅开一片
     * @date 2016年10月14日下午4:19:58
     */
    private static Font setCellFont(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short) 12);
        font.setBoldweight(Font.BOLDWEIGHT_BOLD);
        return font;
    }

    /**
     * 处理Objcet类型的 value
     *
     * @param value
     * @param datePattern
     */
    private static String handleValue(Object value, String datePattern) {
        String textValue = "";
        // 日期类型
        if (value instanceof Date) {
            Date date = (Date) value;
            textValue = DateFormatUtil.date2Str(date, datePattern);
        } else { // 其他类型都当作String处理
            textValue = value == null ? "" : value.toString();
        }
        return textValue;
    }
}
