package cc.lechun.framework.common.vo.jms;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;

/**
 * Created by wangxs on 2017/12/15
 * Description: 消息队列发送结果
 */
public class MessageResult implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Logger log = LoggerFactory.getLogger(MessageResult.class);

    public static final String TYPE_ACTIVE="action";//普通消息
    public static final String TYPE_ORDER_ACTIVE="orderAction";// 顺序消息

    public static final String SOURCE_SEND="SEND";// 发送消息
    public static final String SOURCE_LISTENER="LISTENER";// 接受消息


    public MessageResult() {
    }

    private boolean status;
    private SendResult sendResult;
    private Message msg;
    private String type;
    private String source;// 发送消息/接受消息

    public MessageResult(boolean status, SendResult sendResult, Message msg,String type,String source) {
        this.status = status;
        this.sendResult = sendResult;
        this.msg = msg;
        this.type=type;
        this.source=source;
    }

    public boolean isStatus() {
        return status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public SendResult getSendResult() {
        return sendResult;
    }

    public void setSendResult(SendResult sendResult) {
        this.sendResult = sendResult;
    }

    public Message getMsg() {
        return msg;
    }

    public void setMsg(Message msg) {
        this.msg = msg;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static String getMessageResultJson(boolean status, SendResult sendResult, Message msg, String type, String source) {
        try {
            return JSON.toJSONString(new MessageResult(status, new SendResult(), msg,type,source), false);
        } catch (Exception e) {
            log.error("封装消息结果失败", e);
        }
        return "";
    }

    @Override
    public String toString() {
        return "MessageResult{" +
                "status=" + status +
                ", sendResult=" + sendResult +
                ", msg=" + msg +
                ", type='" + type + '\'' +
                ", source='" + source + '\'' +
                '}';
    }
}
