/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.enums.pay;

import java.util.Arrays;
import java.util.List;

public enum PayTypeEnum {
    WECHAT_PAY(2, "wechatPay"),
    COUPON_PAY(3, "couponPay"),
    ALIPAY_PAY(6, "alipay"),
    BANK_PAY(7, "bankPay"),
    BALANCE_PAY(8, "balancePay"),
    GIFT_PAY(9, "giftPay"),
    OFFLINE_PAY(10, "offLinePay"),
    MILKBANK_PAY(11, "milkBankPay");

    private int value;
    private String name;

    public static List<PayTypeEnum> getList() {
        return Arrays.asList(PayTypeEnum.values());
    }

    public static String getName(int value) {
        PayTypeEnum[] ls;
        for (PayTypeEnum rs : ls = PayTypeEnum.values()) {
            if (rs.getValue() != value) continue;
            return rs.getName();
        }
        return "";
    }

    public static String getPayTypeName(int paytype) {
        switch (paytype) {
            case 2: {
                return "\u5fae\u4fe1\u652f\u4ed8";
            }
            case 3: {
                return "\u4f18\u60e0\u5238\u652f\u4ed8";
            }
            case 6: {
                return "\u652f\u4ed8\u5b9d\u652f\u4ed8";
            }
            case 7: {
                return "\u7f51\u94f6\u652f\u4ed8";
            }
            case 8: {
                return "\u4f59\u989d\u652f\u4ed8";
            }
            case 9: {
                return "\u793c\u7269\u5151\u6362";
            }
            case 10: {
                return "\u73b0\u91d1\u652f\u4ed8";
            }
        }
        return "";
    }

    public static int getValue(String name) {
        PayTypeEnum[] ls;
        for (PayTypeEnum rs : ls = PayTypeEnum.values()) {
            if (!rs.getName().equals(name)) continue;
            return rs.getValue();
        }
        return 0;
    }

    private PayTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "PayTypeEnum{value='" + this.value + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

