/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    public static String now(String format) {
        if (StringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }

    public static String date() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }

    public static Date currentDate() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        String d = f.format(new Date());
        return DateUtils.getDateFromString(d, format);
    }

    public static Date now() {
        return new Date();
    }

    public static long nowMillis() {
        return System.currentTimeMillis();
    }

    public static Date StrToDate(String str, String fm) {
        if (StringUtils.isEmpty((String)fm)) {
            fm = "yyyy-MM-dd HH:mm:ss";
        }
        if (str != null) {
            SimpleDateFormat format = new SimpleDateFormat(fm);
            Date date = null;
            try {
                date = format.parse(str);
            }
            catch (ParseException e) {
                log.error("", (Throwable)e);
            }
            return date;
        }
        return null;
    }

    public static String taskDateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("s m H d M ? yyyy");
        Date now = new Date();
        String cron = null;
        cron = now.getTime() > date.getTime() ? sdf.format(new Date(now.getTime() + 5000L)) : sdf.format(date);
        return cron;
    }

    public static String formatDate(Date sourceDate, String format) {
        if (sourceDate == null) {
            return "";
        }
        if (format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        return dateFormat.format(calendar.getTime());
    }

    public static Date getAddDate(Date sourceDate, int type, int count) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(type, count);
        return calendar.getTime();
    }

    public static Date getAddDateByDay(Date sourceDate, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date getAddDateBySecond(Date sourceDate, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(13, second);
        return calendar.getTime();
    }

    public static String getAddDateBySecond(Date sourceDate, int second, String format) {
        if (format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(DateUtils.getAddDateBySecond(sourceDate, second));
    }

    public static Date getDateFromString(String k, String dateformat) {
        if (dateformat.isEmpty()) {
            dateformat = "yyyy-MM-dd HH:mm:ss";
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateformat);
            format.setLenient(false);
            return format.parse(k);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateFromString(String k) {
        return DateUtils.getDateFromString(k, "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean checkDate(String k, String dateformat) {
        return DateUtils.getDateFromString(k, dateformat) != null;
    }

    public static long dateTimeCompare(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 1000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long dateCompare(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long dateTimeCompare(Date sdate, Date edate) {
        long day = (edate.getTime() - sdate.getTime()) / 1000L;
        return day;
    }

    public static long getDateDiffSecond(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 1000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long getDateDiffSecond(Date sdate, Date edate) {
        long day = 0L;
        try {
            day = (edate.getTime() - sdate.getTime()) / 1000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static String getWeekOfDate(Date date) {
        int w;
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return weekOfDays[w];
    }

    public static int getWeekIndexOfDate(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return w == 0 ? 7 : w;
    }

    public static String getWeekOfDate(int weekIndex) {
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        if (weekIndex >= 0 && weekIndex <= 6) {
            return weekOfDays[weekIndex];
        }
        return "";
    }

    public static String getShortWeekOfDate(int weekIndex) {
        String s = DateUtils.getWeekOfDate(weekIndex);
        return s.replace("\u661f\u671f", "\u5468");
    }

    public static String getShortWeekOfDate(Date date) {
        String s = DateUtils.getWeekOfDate(date);
        return s.replace("\u661f\u671f", "\u5468");
    }

    public static String formatDateChina(String SourceDate, String format) {
        Date d = new Date(DateUtils.dateToTimestamp(SourceDate) * 1000L);
        if (format.isEmpty()) {
            format = "MM\u6708dd\u65e5";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        return dateFormat.format(calendar.getTime());
    }

    public static long dateToTimestamp(String dateString) {
        return DateUtils.dateToTimestamp(dateString, "yyyy-MM-dd HH:mm:ss");
    }

    public static long dateToTimestamp(String dateString, String format) {
        try {
            Date date;
            SimpleDateFormat df = new SimpleDateFormat(format);
            try {
                date = df.parse(dateString);
            }
            catch (ParseException e) {
                df = new SimpleDateFormat("yyyy-MM-dd");
                date = df.parse(dateString);
            }
            long s = date.getTime();
            return s / 1000L;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public static String getDateName(String date) {
        if (date == null || date.isEmpty()) {
            return "7\u65e5\u540e";
        }
        int l = (int)DateUtils.getDateDiff(DateUtils.date(), date);
        if (l == 0) {
            return "\u4eca\u65e5";
        }
        if (l == 1) {
            return "\u660e\u65e5";
        }
        if (l == 2) {
            return "\u540e\u65e5";
        }
        return DateUtils.formatDateChina(date, "M\u6708d\u65e5");
    }

    public static long getDateDiff(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long getDateDiff(Date sdate, Date edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = format.format(sdate);
            String endDate = format.format(edate);
            return DateUtils.getDateDiff(startDate, endDate);
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

