/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class FileUtils {
    private static final long serialVersionUID = 6841417839693317734L;

    private FileUtils() {
    }

    public static InputStream getResourceStream(String relativePath) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(relativePath);
    }

    public static void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeFileOutputStream(FileOutputStream fos) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String extractDirPath(String filePath) {
        int separatePos = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        return separatePos == -1 ? null : filePath.substring(0, separatePos);
    }

    public static String extractFileName(String filePath) {
        int separatePos = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        return separatePos == -1 ? null : filePath.substring(separatePos + 1, filePath.length());
    }

    public static File makeFile(String filePath) {
        String dirPath;
        File file = new File(filePath);
        if (file.isFile()) {
            return file;
        }
        if (filePath.endsWith("/") || filePath.endsWith("\\")) {
            try {
                throw new IOException(filePath + " is a directory");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((dirPath = FileUtils.extractDirPath(filePath)) != null) {
            FileUtils.makeFolder(dirPath);
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static boolean makeFolder(String folderPath) {
        try {
            File myFilePath = new File(folderPath);
            if (!myFilePath.exists()) {
                myFilePath.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean deleteFile(String filePathAndName) {
        try {
            File myDelFile = new File(filePathAndName);
            if (myDelFile.exists()) {
                myDelFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void deleteAllFile(String path, boolean ifDeleteFolder) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        String temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith("\\") || path.endsWith("/") ? path + tempList[i] : path + File.separator + tempList[i];
            if (new File(temp).isFile()) {
                FileUtils.deleteFile(temp);
                continue;
            }
            if (!new File(temp).isDirectory() || !ifDeleteFolder) continue;
            FileUtils.deleteAllFile(path + File.separator + tempList[i], ifDeleteFolder);
            FileUtils.deleteFolder(path + File.separator + tempList[i]);
        }
    }

    public static void deleteFolder(String folderPath) {
        try {
            File myFilePath = new File(folderPath);
            if (myFilePath.exists()) {
                FileUtils.deleteAllFile(folderPath, true);
                myFilePath.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String sourcePath, String targetPath) {
        FileInputStream inStream = null;
        FileOutputStream fos = null;
        try {
            int byteSum = 0;
            int byteRead = 0;
            File sourcefile = new File(sourcePath);
            if (sourcefile.exists()) {
                inStream = new FileInputStream(sourcePath);
                String dirPath = FileUtils.extractDirPath(targetPath);
                if (dirPath != null) {
                    FileUtils.makeFolder(dirPath);
                }
                fos = new FileOutputStream(targetPath);
                byte[] buffer = new byte[1444];
                while ((byteRead = ((InputStream)inStream).read(buffer)) != -1) {
                    byteSum += byteRead;
                    fos.write(buffer, 0, byteRead);
                }
                System.out.println("File size is: " + byteSum);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtils.closeInputStream(inStream);
            FileUtils.closeFileOutputStream(fos);
        }
    }

    public static String makeFilePath(String folderPath, String fileName) {
        return folderPath.endsWith("\\") || folderPath.endsWith("/") ? folderPath + fileName : folderPath + File.separatorChar + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(String sourcePath, String targetPath) {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            FileUtils.makeFolder(targetPath);
            String[] file = new File(sourcePath).list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                String tempPath = FileUtils.makeFilePath(sourcePath, file[i]);
                temp = new File(tempPath);
                String target = "";
                if (temp.isFile()) {
                    input = new FileInputStream(temp);
                    target = FileUtils.makeFilePath(targetPath, file[i]);
                    output = new FileOutputStream(target);
                    byte[] b = new byte[5120];
                    int len = 0;
                    int sum = 0;
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                        sum += len;
                    }
                    target = target + "";
                    output.flush();
                    FileUtils.closeInputStream(input);
                    FileUtils.closeFileOutputStream(output);
                    continue;
                }
                if (!temp.isDirectory()) continue;
                FileUtils.copyFolder(sourcePath + '/' + file[i], targetPath + '/' + file[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtils.closeInputStream(input);
            FileUtils.closeFileOutputStream(output);
        }
    }

    public static void moveFile(String oldFilePath, String newFilePath) {
        FileUtils.copyFile(oldFilePath, newFilePath);
        FileUtils.deleteFile(oldFilePath);
    }

    public static void moveFolder(String oldFolderPath, String newFolderPath) {
        FileUtils.copyFolder(oldFolderPath, newFolderPath);
        FileUtils.deleteFolder(oldFolderPath);
    }

    public static ArrayList<String> getFilePathFromFolder(String filePath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File file = new File(filePath);
        try {
            File[] tempFile = file.listFiles();
            for (int i = 0; i < tempFile.length; ++i) {
                if (!tempFile[i].isFile()) continue;
                String tempFileName = tempFile[i].getName();
                fileNames.add(FileUtils.makeFilePath(filePath, tempFileName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileNames;
    }

    public static ArrayList<String> getAllFilePathFromFolder(String filePath) {
        ArrayList<String> filePaths = new ArrayList<String>();
        File file = new File(filePath);
        try {
            File[] tempFile = file.listFiles();
            for (int i = 0; i < tempFile.length; ++i) {
                String tempFileName = tempFile[i].getName();
                String path = FileUtils.makeFilePath(filePath, tempFileName);
                if (tempFile[i].isFile()) {
                    filePaths.add(path);
                    continue;
                }
                ArrayList<String> tempFilePaths = FileUtils.getAllFilePathFromFolder(path);
                if (tempFilePaths.size() <= 0) continue;
                for (String tempPath : tempFilePaths) {
                    filePaths.add(tempPath);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filePaths;
    }

    public static ArrayList getFileNameFromFolder(String filePath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File file = new File(filePath);
        File[] tempFile = file.listFiles();
        for (int i = 0; i < tempFile.length; ++i) {
            if (!tempFile[i].isFile()) continue;
            fileNames.add(tempFile[i].getName());
        }
        return fileNames;
    }

    public static int getFileCount(String filePath) {
        int count = 0;
        try {
            File file = new File(filePath);
            if (!FileUtils.isFolderExist(filePath)) {
                return count;
            }
            File[] tempFile = file.listFiles();
            for (int i = 0; i < tempFile.length; ++i) {
                if (!tempFile[i].isFile()) continue;
                ++count;
            }
        }
        catch (Exception fe) {
            count = 0;
        }
        return count;
    }

    public static int getFileCount(String filePath, String matchs) {
        int count = 0;
        if (!FileUtils.isFolderExist(filePath)) {
            return count;
        }
        if (matchs.equals("") || matchs == null) {
            return FileUtils.getFileCount(filePath);
        }
        File file = new File(filePath);
        File[] tempFile = file.listFiles();
        for (int i = 0; i < tempFile.length; ++i) {
            if (!tempFile[i].isFile() || !Pattern.matches(matchs, tempFile[i].getName())) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStrCountFromFile(String filePath, String str) {
        if (!FileUtils.isFileExist(filePath)) {
            return 0;
        }
        FileReader fr = null;
        BufferedReader br = null;
        int count = 0;
        try {
            fr = new FileReader(filePath);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf(str) == -1) continue;
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLineCount(String filePath) {
        if (!FileUtils.isFileExist(filePath)) {
            return 0;
        }
        FileReader fr = null;
        BufferedReader br = null;
        int count = 0;
        try {
            fr = new FileReader(filePath);
            br = new BufferedReader(fr);
            while (br.readLine() != null) {
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public static boolean ifFileIsNull(String filePath) throws IOException {
        boolean result = false;
        FileReader fr = new FileReader(filePath);
        if (fr.read() == -1) {
            result = true;
        }
        fr.close();
        return result;
    }

    public static boolean isFileExist(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        File file = new File(fileName);
        return file.exists() && !file.isDirectory();
    }

    public static boolean isFolderExist(String folderPath) {
        File file = new File(folderPath);
        return file.isDirectory();
    }

    public static Double getFileSize(String filePath) {
        if (!FileUtils.isFileExist(filePath)) {
            return null;
        }
        File file = new File(filePath);
        double intNum = Math.ceil((double)file.length() / 1024.0);
        return new Double(intNum);
    }

    public static Double getFileByteSize(String filePath) {
        if (!FileUtils.isFileExist(filePath)) {
            return null;
        }
        File file = new File(filePath);
        double intNum = Math.ceil(file.length());
        return new Double(intNum);
    }

    public static Double getWhpjFileSize(String filePath) {
        if (!FileUtils.isFileExist(filePath)) {
            return null;
        }
        File file = new File(filePath);
        return new Double(file.length());
    }

    public static String fileModifyTime(String filePath) {
        if (!FileUtils.isFileExist(filePath)) {
            return null;
        }
        File file = new File(filePath);
        long timeStamp = file.lastModified();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        String tsForm = formatter.format(new Date(timeStamp));
        return tsForm;
    }

    public static ArrayList getFilesSizeModifyTime(String folderPath) {
        ArrayList returnList = new ArrayList();
        ArrayList<String> filePathList = FileUtils.getFilePathFromFolder(folderPath);
        for (int i = 0; i < filePathList.size(); ++i) {
            ArrayList<Object> tempList = new ArrayList<Object>();
            String filePath = (String)filePathList.get(i);
            String modifyTime = FileUtils.fileModifyTime(filePath);
            Double fileSize = FileUtils.getFileSize(filePath);
            tempList.add(filePath);
            tempList.add(modifyTime);
            tempList.add(fileSize);
            returnList.add(tempList);
        }
        return returnList;
    }

    public static ArrayList getTxtFileNameFromFolder(String filePath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File file = new File(filePath);
        File[] tempFile = file.listFiles();
        for (int i = 0; i < tempFile.length; ++i) {
            if (!tempFile[i].isFile() || tempFile[i].getName().indexOf("TXT") == -1 && tempFile[i].getName().indexOf("txt") == -1) continue;
            fileNames.add(tempFile[i].getName());
        }
        return fileNames;
    }

    public static ArrayList getXmlFileNameFromFolder(String filePath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File file = new File(filePath);
        File[] tempFile = file.listFiles();
        for (int i = 0; i < tempFile.length; ++i) {
            if (!tempFile[i].isFile() || tempFile[i].getName().indexOf("XML") == -1 && tempFile[i].getName().indexOf("xml") == -1) continue;
            fileNames.add(tempFile[i].getName());
        }
        return fileNames;
    }

    public static boolean checkFile(String fileName, HashMap mapErrorMessage) {
        if (mapErrorMessage == null) {
            mapErrorMessage = new HashMap<String, String>();
        }
        if (fileName == null) {
            fileName = "";
        }
        if (fileName.length() == 0) {
            mapErrorMessage.put("errorMessage", "fileName length is 0");
            return false;
        }
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            mapErrorMessage.put("errorMessage", fileName + "is not exist!");
            return false;
        }
        return true;
    }

    public static boolean checkFile(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        if (fileName.length() == 0) {
            return false;
        }
        File file = new File(fileName);
        return file.exists() && !file.isDirectory();
    }

    public static void newFolder(String folderPath) {
        try {
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            if (!myFilePath.exists()) {
                myFilePath.mkdir();
            }
        }
        catch (Exception e) {
            System.out.println("\u65b0\u5efa\u76ee\u5f55\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public static void sessionData(String path, List<List> list) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(path));
        for (List tempList : list) {
            for (String str : tempList) {
                if (str == null || str.equals("")) continue;
                bw.write(str);
                bw.newLine();
                bw.flush();
            }
        }
        bw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareUrl(String urladdr, String filePath, FileChannel fc) {
        boolean isExist = false;
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            int sz = (int)fc.size();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            CharBuffer cb = decoder.decode(bb);
            String s = String.valueOf(cb);
            int n = s.indexOf(urladdr);
            if (n <= -1) {
                isExist = true;
            }
        }
        catch (Exception exception) {}
        return isExist;
    }
}

