package cc.lechun.framework.common.utils.serviceresult;

import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.stereotype.Component;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Component
public class LogUtil {

	@Resource
	private HttpServletRequest request;

	public Object[] setLoggerContent(String remarks){

		BaseUser user =null;
        String ip = null;
        try{
            user = JedisUtils.getBaseUser(request);
            ip = getIpAddr(request);
        }catch (Exception e){
            ip="127.0.0.1";
            e.printStackTrace();
        }
		//SysUserBO user =  SessionUtil.getLoginUserInfo();


    	String cTenantID = user != null ? user.getCtenantid() : "300846";
    	String userName = user != null ? user.getEmployeeName() : "系统管理员";

    	Object[] argArray = new Object[]{cTenantID,userName,ip,remarks};
    	return argArray;
	}
	
	public String getColumn4(){
		return "URI:{},{},{},{}";
	}
	
	public Marker getQueryMarker(){
		return MarkerFactory.getMarker("SQL");
	}
	
	/**
     * 获取ip
     * @param request
     * @return
     */
    private String getIpAddr(HttpServletRequest request) {
		
        String ip = request.getHeader("x-forwarded-for");  
         
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
           ip = request.getHeader("Proxy-Client-IP");  
        }  
         
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
           ip = request.getHeader("WL-Proxy-Client-IP");  
        }  
         
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
           ip = request.getRemoteAddr();  
        }  
        return ip;  
     }


}
