package cc.lechun.framework.common.enums.sales;

import java.util.Arrays;
import java.util.List;

/**
 * Created by anyhow on 2018/1/24.
 */
public enum TransportTypeEnum {

    COLD_CHAIN(1, "冷链"),
    NORMAL_CHAIN(2, "非冷链"),
    ONLINE_SEND(3,"线上兑换");
    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<TransportTypeEnum> getList() {
        return Arrays.asList(TransportTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        TransportTypeEnum[] ls = TransportTypeEnum.values();
        for (TransportTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        TransportTypeEnum[] ls = TransportTypeEnum.values();
        for (TransportTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    /**
     * 通过value获取名称
     */
    public static TransportTypeEnum getTransportTypeEnum(int value) {
        TransportTypeEnum[] ls = TransportTypeEnum.values();
        for (TransportTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs;
            }
        }
        return null;
    }
    TransportTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "TransportTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
