package cc.lechun.framework.common.utils.conditions;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * @Description:
 * @Author hans
 * @Date 2019/12/13 11:24
 * @Version 1.0
 */
public class LocalEnvironmentCondition implements Condition {
    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment env = conditionContext.getEnvironment();
        String environment = env.getProperty("lechun.environment");
        if("local".equals(environment) || "localhost".equals(environment) || "dev".equals(environment) || "development".equals(environment)){
            return true;
        }
        return false;
    }
}
