package cc.lechun.framework.common.utils.object;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.util.HashMap;
import java.util.Map;

/**
 * 替换指定字符
 */
public class SpELUtils {

    /**
     * 单一对象注入
     *
     * @param expr #{user.id}.#{user.name}.#{user.tel}
     * @param data
     * @return
     */
    public static String readExpr(String expr, Object data) {
        ExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(expr, new TemplateParserContext());
        return expression.getValue(data, String.class);
    }

    /**
     * 多个变量注入
     *
     * @param expr #{#shopId}.#{#typeId}.#{#paging.page}
     * @param map
     * @return
     */
    public static String readExpr(String expr, Map<String, Object> map) {
        ExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(expr, new TemplateParserContext());
        EvaluationContext context = new StandardEvaluationContext();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            context.setVariable(entry.getKey(), entry.getValue());
        }
        return expression.getValue(context, String.class);
    }



}