package cc.lechun.framework.common.utils.validate;

import cc.lechun.framework.common.utils.string.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.routines.DateValidator;

public class DateValidatorUsingCommonsValidator  {
    private static final String[] dateFormat={"yyyy-MM-dd","yyyy-M-d","yyyy-MM-d","yyyy-M-dd","yyyyMMdd"};
    private static final String[] dateTimeFormat={"HH:mm:ss","HH:mm:s","HH:m:s","H:mm:ss","H:mm:s","H:m:s","HHmmss"};
    public static boolean isDate(String dateStr) {
        if(StringUtils.isEmpty(dateStr)){
            return true;
        }
        dateStr=dateStr.replace("/","-");
        for(String f:dateFormat) {
            if(GenericValidator.isDate(dateStr, f, true)){
                return true;
            }
        }
        return false;
    }
    public static boolean isDateTime(String dateStr) {
        if(StringUtils.isEmpty(dateStr)){
            return true;
        }
        if(dateStr.indexOf(" ")<0){
            return false;
        }
        dateStr=dateStr.replace("/","-");
        String date=dateStr.split(" ")[0];
        String time=dateStr.split(" ")[1];
        if(isDate(date)) {
            for (String f : dateTimeFormat) {
                if (GenericValidator.isDate(time, f, true)) {
                    return true;
                }
            }
        }
        return false;
    }
    public static boolean isTime(String dateStr) {
        if(StringUtils.isEmpty(dateStr)){
            return true;
        }

        for (String f : dateTimeFormat) {
            if (GenericValidator.isDate(dateStr, f, true)) {
                return true;
            }
        }

        return false;
    }
}