package cc.lechun.framework.common.utils.web;

import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/**
 * Created by wangxs on 2017/12/13
 * Description: 通过请求获取请求内包含的信息
 */
public class RequestDetail {

    private final static Logger log = LoggerFactory.getLogger(RequestDetail.class);

    /**
     * 从请求中获取参数 设置默认值
     */
    public static String getRequestString(HttpServletRequest request, String key, String defaultValue) {
        String value = request.getParameter(key);
        return value != null ? value : defaultValue;
    }

    public static int getRequestInt(HttpServletRequest request, String key, int defaultValue) {
        String value = request.getParameter(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public static long getRequestLong(HttpServletRequest request, String key, long defaultValue) {
        String value = request.getParameter(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public static double getRequestDouble(HttpServletRequest request, String key, double defaultValue) {
        String value = request.getParameter(key);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    public static HttpServletRequest getCurrentRequest() {
        try {
            RequestAttributes s=RequestContextHolder.currentRequestAttributes();
            if(s!=null) {
                ServletRequestAttributes attributes = (ServletRequestAttributes) s;
                return attributes.getRequest();
            }
        }catch (Exception e){
            //e.printStackTrace();
        }
        return null;
    }

    public static HttpServletResponse getCurrentResponse() {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.currentRequestAttributes();
        return attributes.getResponse();
    }

    /**
     * 获取域名   通过公司获取
     */
    public static String getDomain(HttpServletRequest request) {
        try {
            String server = request.getServerName();
            int start = server.indexOf(".") + 1;
            String domain = server.substring(start);
            return domain;
        } catch (Exception e) {
            log.error("", e);
        }
        return null;
    }

    /**
     * 完整的URL
     * 如：http://lechun.com/h5/order/info?orderId=123
     */
    public static String getFullUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        if (StringUtils.isNotEmpty(request.getQueryString())) {
            url = String.format("%s?%s", url, request.getQueryString());
        }
        return url;
    }

    /**
     * 域名后面的部分
     * 如：/h5/order/info?orderId=123
     */
    public static String getFullUri(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (StringUtils.isNotEmpty(request.getQueryString())) {
            url = url + "?" + request.getQueryString();
        }
        return url;
    }

    /**
     * 页面的域名
     * 如：wx.lechun.cc
     */
    public static String getPageDomain(HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        if (StringUtils.isNotEmpty(origin)) {
            origin = origin.split("//")[1];
            origin = origin.split("/")[0];
        } else {
            origin = request.getHeader("Referer");
            if (StringUtils.isNotEmpty(origin)) {
                origin = origin.split("//")[1];
                origin = origin.split("/")[0];
            }
        }
        return origin;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return request.getHeader("accept") != null && request.getHeader("accept").indexOf("application/json") != -1;
    }

    /**
     * 给请求参数签名
     */
    public static String md5MallSign(HttpServletRequest request, String key) {
        Map<String, String[]> map = request.getParameterMap();
        TreeSet<String> set = new TreeSet<String>(map.keySet());
        set.remove("app_type");
        set.remove("user_type");
        set.remove("device_id");
        set.remove("location");
        set.remove("language");
        set.remove("version_code");
        set.remove("user_agent");
        set.remove("app_platform");
        set.remove("call_id");
        set.remove("ticket");
        set.remove("sign");
        set.remove("sign_method");
        set.remove("callback");
        set.remove("fresh");
        set.remove("_");
        set.remove("channel_id");
        set.remove("ip_addr");
        set.remove("url");
        set.remove("frompage");
        set.remove("USER_IMG");
        set.remove("USER_FILE");
        set.remove("callbackType");
        set.remove("testId");
        Iterator i = set.iterator();
        String p = "";
        while (i.hasNext()) {
            String i0 = i.next().toString();
            p += i0.trim() + ":" + RequestDetail.getRequestString(request, i0, "").trim().replace(" ", "") + ",";
        }
        if (p.lastIndexOf(",") > 0)
            p = p.substring(0, p.length() - 1);
        return MD5.sign(p + "_" + key, "").toLowerCase();
    }


    //返回值类型为Map<String, String>
    public static Map<String, String> getParameterStringMap(HttpServletRequest request) {
        Map<String, String[]> properties = request.getParameterMap();//把请求参数封装到Map<String, String[]>中
        Map<String, String> returnMap = new HashMap<String, String>();
        String name = "";
        String value = "";
        for (Map.Entry<String, String[]> entry : properties.entrySet()) {
            name = entry.getKey();
            String[] values = entry.getValue();
            if (null == values) {
                value = "";
            } else if (values.length>1) {
                for (int i = 0; i < values.length; i++) { //用于请求参数中有多个相同名称
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = values[0];//用于请求参数中请求参数名唯一
            }
            returnMap.put(name, value);

        }
        return returnMap;
    }
}
