package cc.lechun.common.enums.pay;

import java.util.Arrays;
import java.util.List;

/**
 *子支付方式
 * Description: 枚举
 */
public enum PaySubTypeEnum {
    WECHAT_SUB_PAY(12, "wechatSubPay"),//微信支付
    WECHAT_SUB_SCAN_PAY(4, "wechatSubScanPay"),//微信扫码
    WECHAT_SUB_CARD_PAY(5, "wechatSubCardPay"),//微信刷卡
    WECHAT_SUB_WAP_PAY(13, "wechatSubWapPay"),//微信wap
    WECHAT_SUB_MINI_PAY(14, "wechatSubMiniPay"),//微信小程序
    WECHAT_SUB_ANDROID_PAY(25, "wechatSubAndroidPay"),//微信ANDROID
    WECHAT_SUB_IOS_PAY(26, "wechatSubIosPay"),//微信IOS
    COUPON_SUB_PAY(15, "couponSubPay"),//优惠券支付
    ALIPAYSUB_WAP_PAY(16, "alipaySubWapPay"),//支付宝-wap
    BANK_SUB_CCB_PAY(17,"bankSubCCBPay"),//银行-建行
    BANK_SUB_CMB_PAY(27,"bankSubCMBPay"),//银行-招商
    BALANCE_SUB_CHARGE_PAY(18,"balanceSubChargePay"),//余额-充值余额
    BALANCE_SUB_GIVE_PAY(19,"balanceSubGivePay"),//余额-赠送余额
    BALANCE_SUB_GIFTCARD_PAY(20,"balanceSubGiftCardPay"),//余额-礼品卡
    BALANCE_SUB_CARDPLAN_PAY(28,"balanceSubCardPlanPay"),//余额-奶卡
    ORDER_SUB_AMOUNT_PAY(30,"orderSubAmountPay"),//订单抵扣支付

    GIFT_SUB_PAY(21,"giftSubPay"),//礼物支付
    OFFLINE_SUB_PAY(22,"offLineSubPay"),//线下支付
    MILKBANK_SUB_CHARGE_PAY(11,"milkBankSubChargePay"),//酸奶库-万能
    MILKBANK_SUB_GIVE_PAY(11,"milkBankSubGivePay");//酸奶库-赠送


    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<PaySubTypeEnum> getList() {
        return Arrays.asList(PaySubTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        PaySubTypeEnum[] ls = PaySubTypeEnum.values();
        for (PaySubTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        PaySubTypeEnum[] ls = PaySubTypeEnum.values();
        for (PaySubTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    PaySubTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "PaySubTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
