package cc.lechun.framework.common.utils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.*;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;


/**
 * 用来处理excel的工具类
 * 
 * @author 梅开一片
 * @date 2016年4月19日上午11:14:01
 */
public abstract class ExcelUtil<T> {
	
	private static DecimalFormat df = new DecimalFormat("#");
	public  void getnn(){
		this.getClass().getClassLoader().getResource("selected.txt");
		System.out.println(this.getClass().getClassLoader().getResource("selected.txt"));
		File f = new File(this.getClass().getResource("").getPath());
		System.out.println(f);

	}
	/**
	 * 读取 excel
	 * @author 梅开一片
	 * @date 2016年5月6日上午8:56:19
	 *
	 * @param path 文件路径
	 * @return
	 * @throws IllegalArgumentException
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public static Workbook readExcel(String path)
			throws IllegalArgumentException, FileNotFoundException, IOException {
		if (StringUtils.isBlank(path)) {
			throw new IllegalArgumentException("path is null!");
		}
		
		Workbook workbook = null;
		InputStream is = new FileInputStream(path);
		
		if (path.endsWith(".xls")) {
			// 读取.xls 格式的 excel
			workbook = new HSSFWorkbook(is);
		} else if (path.endsWith(".xlsx")) {
			// 读取.xlsx 格式的 excel
			workbook = new XSSFWorkbook(is);
		} else {
			IOUtils.closeQuietly(is);
			throw new IllegalArgumentException("the path is not excel file!");
		}
		return workbook;
	}
	
	/**
	 * 读取 excel
	 * 
	 * @author 梅开一片
	 * @date 2016年5月6日上午9:03:26
	 * 
	 * @param is
	 *            文件输入流
	 * @param fileName
	 *            excel文件名称
	 * @return
	 * @throws IllegalArgumentException
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public static Workbook readExcel(InputStream is, String fileName)
			throws IllegalArgumentException, FileNotFoundException, IOException {
		if (StringUtils.isBlank(fileName)) {
			throw new IllegalArgumentException("path is null!");
		}

		Workbook workbook = null;
		if (fileName.endsWith(".xls")) {
			// 读取.xls 格式的 excel
			workbook = new HSSFWorkbook(is);
		} else if (fileName.endsWith(".xlsx")) {
			// 读取.xlsx 格式的 excel
			workbook = new XSSFWorkbook(is);
		} else {
			throw new IllegalArgumentException("the path is not excel file!");
		}
		return workbook;
	}

	/**
	 * 从 excel 中读取 期初库存信息
	 *
	 * @param is 文件输入流
	 * @param fileName 文件名
	 * @return
	 * @throws IllegalArgumentException
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public  List<T> readInitInventory(InputStream is, String fileName)
			throws IllegalArgumentException, FileNotFoundException, IOException {
		Workbook workbook = readExcel(is, fileName);
		if (workbook == null) {
			return null;
		}
		return readInitInventory(workbook.getSheetAt(0));
	}


	/**
	 * 从 excel 中读取期初库存信息

	 *
	 * @param sheet
	 * @return
	 * @throws IllegalArgumentException
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public  List<T> readInitInventory(Sheet sheet)
		throws IllegalArgumentException, FileNotFoundException, IOException {
		
		if (sheet == null) {
			System.out.print("<<<<<<空表>>>>>>");
			throw new IllegalArgumentException("sheet is null!");
		}
		
		List<T> initInventoryOs = new LinkedList<>();
		
		// 声明期初库存信息VO对象
		T initInventory = null;

		// 读取 行
		for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); rowNum++) {
			Row row = sheet.getRow(rowNum);

			Cell cell = row.getCell(0);
			// 0 编号
			if (cell == null) {
				break;
			}

			cell = row.getCell(1);
			// 1 名称
			if (cell == null) {
				break;
			}

			initInventory = getObject();

			// 读取 单元格
			for (int columnNum = 0; columnNum < row.getLastCellNum(); columnNum++) {
				cell = row.getCell(columnNum);

				if (isBlank(cell)) {
					continue;
				}

				int columnIndex = cell.getColumnIndex();
				SimpleDateFormat sdf = new SimpleDateFormat(("yyyy/MM/dd"));
				valueToObject(columnIndex,cell,initInventory);
			}
			initInventoryOs.add(initInventory);

		}
		System.out.println("initInventoryOs.size():" + initInventoryOs.size() + "\ninitInventoryOs>>>>>>" + initInventoryOs);
		
		return initInventoryOs;
	}

	public abstract void valueToObject(int columnIndex,Cell cell,T t);
	public abstract T getObject();
	/**
	 * 判断当前单元格是否为 空单元格
	 * @author 梅开一片
	 * @date 2016年5月6日上午9:05:05
	 *
	 * @param cell
	 * @return
	 */
	private static boolean isBlank(Cell cell){
		if(cell == null || cell.getCellType() == Cell.CELL_TYPE_BLANK){
			return true;
		}
		return false;
	}

	/**
	 * 获取单元格cell中的值
	 * @author 梅开一片
	 * @date 2016年5月6日上午9:05:12
	 *
	 * @param cell
	 * @return
	 */
	public  String getValue(Cell cell) {
		if (cell.getCellType() == Cell.CELL_TYPE_BOOLEAN) {
			// 值类型是 boolean 型
			return String.valueOf(cell.getBooleanCellValue());
		} else if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
			// 值类型是数值 numeric 型
			//在excel中，日期和时间类型均存储为数值型
			//判断是否为日期类型
			if(DateUtil.isCellDateFormatted(cell)){
				SimpleDateFormat sdf = null;
				//判断是日期还是时间
				if(cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat("h:mm")) {
					sdf = new SimpleDateFormat("HH:mm");
				} else {
					sdf = new SimpleDateFormat("yyyy-MM-dd");
				}
				Date date = cell.getDateCellValue();
				return sdf.format(date);
			}
			return String.valueOf(cell.getNumericCellValue());
		} else {
			// 字符串型
			String value = cell.getStringCellValue();
			return value == null ? "" : value.trim();
		}
	}

	/**
	 * 获取文件后缀
	 * @author 梅开一片
	 * @date 2016年5月6日上午9:05:34
	 *
	 * @param path
	 * @return
	 */
	public  String getPostfix(String path) {
		String postfix = null;

		if (StringUtils.isNotBlank(path) && path.contains(".")) {
			postfix = path.substring(path.lastIndexOf("."));
		}
		return postfix;
	}
}
