package cc.lechun.framework.common.vo;



import cc.lechun.framework.common.utils.cache.RedisConfig;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Iterator;
import java.util.Set;

/**
 *@ClassNameJedisUtils
 *@Description TODO
 *@Author
 *@Date
 *@Version 1.0
 **/
@RefreshScope
@Component
public class JedisUtils{


    private static RedisConfig redisConfig;

    @Autowired
    public void setRedisConfig(RedisConfig redisConfig){
        JedisUtils.redisConfig = redisConfig;
    }


    //private RedisConfig redisConfig

    public static BaseUser getBaseUser(HttpServletRequest request) {
        String id=request.getHeader("id");
        return getBaseUser(id);
    }
    public static BaseUser getBaseUser(String  id) {
        Set<String> base = redisConfig.redisTemplateString().opsForSet().members(id+"-user");
        if (!base.isEmpty()){
            Iterator it = base.iterator();
            while(it.hasNext()){
                String  bas =it.next().toString();
                BaseUser baseUser=JSON.parseObject(bas,BaseUser.class);
                if(baseUser!=null){
                    return baseUser;
                }
            }
        }
        return null;
    }
}
