/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.sign;

import cc.lechun.framework.common.utils.config.Config;
import cc.lechun.framework.common.utils.sign.EncodeUtils;
import com.sun.crypto.provider.SunJCE;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Base64Utils;

public class AES {
    public static final String NAME = "name";
    public static final String PHONE = "phone";
    private static Map<String, Cipher> enCis = new HashMap<String, Cipher>();
    private static Map<String, Cipher> deCis = new HashMap<String, Cipher>();
    private static Map<String, SecretKey> deSecretKeys = new HashMap<String, SecretKey>();
    private static Map<String, SecretKey> enSecretKeys = new HashMap<String, SecretKey>();
    public static final String AES_KEY = "AES";
    public static final String CODE = "UTF-8";
    public static final int BIT = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateKey(String filePath) {
        filePath = AES.getFullPath(filePath);
        ObjectOutputStream outputStream = null;
        try {
            Security.addProvider(new SunJCE());
            KeyGenerator keygen = KeyGenerator.getInstance(AES_KEY);
            SecretKey deskey = keygen.generateKey();
            outputStream = new ObjectOutputStream(new FileOutputStream(filePath));
            outputStream.writeObject(deskey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getFullPath(String filePath) {
        if (filePath.contains(".aes")) {
            return filePath;
        }
        return Config.value("aes_path") + filePath + ".aes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey getEnSecretKey(String filePath) {
        SecretKey secretKey = enSecretKeys.get(filePath = AES.getFullPath(filePath));
        if (secretKey != null) {
            return secretKey;
        }
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(filePath));
            secretKey = (SecretKey)inputStream.readObject();
            enSecretKeys.put(filePath, secretKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey getDeSecretKey(String filePath) {
        SecretKey secretKey = deSecretKeys.get(filePath = AES.getFullPath(filePath));
        if (secretKey != null) {
            return secretKey;
        }
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(filePath));
            secretKey = (SecretKey)inputStream.readObject();
            deSecretKeys.put(filePath, secretKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encrytor(String key, String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        String string = key = AES.getFullPath(key);
        synchronized (string) {
            try {
                byte[] src = str.getBytes();
                byte[] cipherByte = AES.getEnCi(key).doFinal(src);
                return Base64Utils.encodeToString((byte[])cipherByte);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static Cipher getEnCi(String filePath) {
        Cipher ci = enCis.get(filePath);
        if (ci != null) {
            return ci;
        }
        try {
            ci = Cipher.getInstance(AES_KEY);
            ci.init(1, AES.getEnSecretKey(filePath));
            enCis.put(filePath, ci);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptor(String key, String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        String string = key = AES.getFullPath(key);
        synchronized (string) {
            try {
                byte[] src = Base64Utils.decodeFromString((String)str);
                byte[] cipherByte = AES.getDeCi(key).doFinal(src);
                return new String(cipherByte);
            }
            catch (Exception e) {
                e.printStackTrace();
                deCis.remove(key);
                return null;
            }
        }
    }

    private static Cipher getDeCi(String filePath) {
        Cipher ci = deCis.get(filePath);
        if (ci != null) {
            return ci;
        }
        try {
            ci = Cipher.getInstance(AES_KEY);
            ci.init(2, AES.getDeSecretKey(filePath));
            deCis.put(filePath, ci);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ci;
    }

    public static byte[] getSecretKey(String password) throws NoSuchAlgorithmException {
        byte[] enCodeFormat = null;
        KeyGenerator kgen = KeyGenerator.getInstance(AES_KEY);
        if (StringUtils.isEmpty((CharSequence)password)) {
            kgen.init(128);
        } else {
            kgen.init(128, new SecureRandom(password.getBytes()));
        }
        SecretKey secretKey = kgen.generateKey();
        enCodeFormat = secretKey.getEncoded();
        return enCodeFormat;
    }

    public static byte[] encrypt(String content, String password) {
        byte[] result = null;
        try {
            byte[] enCodeFormat = AES.getSecretKey(password);
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, AES_KEY);
            Cipher cipher = Cipher.getInstance(AES_KEY);
            byte[] byteContent = content.getBytes(CODE);
            cipher.init(1, key);
            result = cipher.doFinal(byteContent);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] decrypt(byte[] content, String password) {
        byte[] result = null;
        try {
            byte[] enCodeFormat = AES.getSecretKey(password);
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, AES_KEY);
            Cipher cipher = Cipher.getInstance(AES_KEY);
            cipher.init(2, key);
            result = cipher.doFinal(content);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String setEncrypt(String key, String content) {
        String value = "";
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            value = EncodeUtils.base64Encode(AES.encrypt(content, key));
        }
        return value;
    }

    public static String getDecrypt(String key, String content) {
        String value = "";
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            value = new String(AES.decrypt(EncodeUtils.base64Decode(content), key));
        }
        return value;
    }
}

