/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.web;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static void corsConfig(HttpServletRequest request, HttpServletResponse httpServletResponse) {
        String curOrigin = request.getHeader("Origin");
        if (!StringUtils.isEmpty((String)curOrigin)) {
            httpServletResponse.setHeader("Access-Control-Allow-Origin", curOrigin);
            httpServletResponse.setHeader("Access-Control-Allow-Credentials", "true");
        }
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json; charset=utf-8");
        if (request.getMethod().equals("OPTIONS")) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "*");
            httpServletResponse.setHeader("Access-Control-Allow-Headers", "Content-Type,Access-Token");
            httpServletResponse.setHeader("Access-Control-Expose-Headers", "*");
        }
    }

    public static void corsConfigFilter(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type,Access-Token");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("content-type", "application/json;charset=UTF-8");
    }

    public static void writeCorsJsonDate(HttpServletRequest request, HttpServletResponse httpServletResponse, Object obj) throws IOException {
        ResponseUtils.corsConfig(request, httpServletResponse);
        httpServletResponse.getWriter().print(JSON.toJSONString((Object)obj));
    }
}

