/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.ids;

import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.aspectj.apache.bcel.util.ClassPath;

public class OrderNoUtils {
    private static final String WORKERID_PATH = ClassPath.getClassPath() + "/workerId";
    private static String lastNo = "";
    private long workerId = 1L;
    private long sequence = 1L;
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long datacenterIdShift = 22L;
    private final long sequenceMask = 4095L;
    private final long timestampLeftShift = 22L;
    private long lastTimestamp = -1L;

    private OrderNoUtils() {
    }

    public static OrderNoUtils getInstance() {
        return OrderNoUtilsHolder.instance;
    }

    public String create() {
        return this.nextNo();
    }

    private String nextNo() {
        return this.nextNo(this.workerId);
    }

    private synchronized String nextNo(long workerId) {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new IllegalStateException("Clock moved backwards.");
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long id = timestamp % 1000L << 22 | workerId << 12 | this.sequence;
        String timestampStr = DateFormatUtils.format((long)timestamp, (String)"yyyyMMddHHmmss");
        return timestampStr + String.format("%010d", id);
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static String genId(String machineId) throws InterruptedException {
        String orderId = machineId + System.nanoTime();
        orderId = String.valueOf(orderId.hashCode());
        while (lastNo.equals(orderId)) {
            orderId = machineId + (System.currentTimeMillis() + "").substring(1) + '-' + (System.nanoTime() + "").substring(7, 10);
        }
        lastNo = orderId;
        return orderId;
    }

    public static String getOrderIdByUUId(String machineId) {
        int hashCodeV = UUID.randomUUID().toString().hashCode();
        if (hashCodeV < 0) {
            hashCodeV = -hashCodeV;
        }
        String orderId = machineId + String.format("%015d", hashCodeV);
        return orderId;
    }

    private static class OrderNoUtilsHolder {
        private static OrderNoUtils instance = new OrderNoUtils();

        private OrderNoUtilsHolder() {
        }
    }
}

