package cc.lechun.framework.common.enums.customer;

import java.util.Arrays;
import java.util.List;

/**
 * Created by anyhow on 2018/3/27.
 */
public enum VipRightTypeEnum {
    RIGHT_DANPIN_ZHEKOU(1, "会员日单品折扣"),
    RIGHT_TAOZHUANG_ZHEKOU(2, "会员专属套装折扣"),
    RIGHT_XINPINCHANGXIAN(3, "新品尝鲜"),
    RIGHT_MIAOSHA(4,"秒杀"),
    RIGHT_TIQIANMIAOSHA(5,"提前秒杀(已弃用）"),
    RIGHT_SIRENLIPIN_ZIFEI(6,"5元私人定制礼品"),
    RIGHT_SIRENLIPIN_MIANFEI(7,"免费私人定制礼品"),
    RIGHT_LV4_ZHUANSHUZENGLI(8,"LV4专属赠品"),
    RIGHT_LV5_ZHUANSHUZENGLI(9,"LV5专属赠品"),
    RIGHT_FOODIE_PASS(10,"Foodie Pass商城"),
    RIGHT_MENDIAN_YONGJIUZHEKOU(11,"门店随时9折"),
    RIGHT_MISOASHAYUYUE(12,"秒杀预约"),
    RIGHT_SHEQUN(13,"社群"),
    RIGHT_ZHUANSHUZENGLI(14,"专属赠礼"),
    RIGHT_SHENGRIZENGLI(15,"生日赠礼"),
    RIGHT_RICHANGDANPIN_ZHEKOU(16,"日常单品折扣");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<VipRightTypeEnum> getList() {
        return Arrays.asList(VipRightTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        VipRightTypeEnum[] ls = VipRightTypeEnum.values();
        for (VipRightTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        VipRightTypeEnum[] ls = VipRightTypeEnum.values();
        for (VipRightTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    VipRightTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "VipRightTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
