package cc.lechun.framework.common.enums.sync;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/5/23
 * Description:
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DataSyncStatusEnum {

    BI_ORDER(1, "BI_ORDER"),
    BI_PRODUCT(2,"BI_PRODUCT");


    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<DataSyncStatusEnum> getList() {
        return Arrays.asList(DataSyncStatusEnum.values());
    }
    public static int getValuseSum(){
        int i=0;
        for(DataSyncStatusEnum v:DataSyncStatusEnum.values()){
            i+=v.value;
        }
        return i;
    }
    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        DataSyncStatusEnum[] ls = DataSyncStatusEnum.values();
        for (DataSyncStatusEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    DataSyncStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
