package cc.lechun.framework.common.utils.date;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by wangxs on 2017/12/11
 * Description: 时间工具类
 */
public class DateUtils {
    private final static SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final static SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private final static SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");
    private final static Logger log = LoggerFactory.getLogger(DateUtils.class);

    /**
     * 获取当前时间
     */
    public static String now(String format) {
        if (StringUtils.isEmpty(format)) format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }
    /**
     * 获取当前日期
     */
    public static String date() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }
    /**
     * 获取当前日期
     */
    public static Date currentDate() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        String d= f.format(new Date());
        return getDateFromString(d,format);
    }
    /**
     * 获取当前时间
     */
    public static Date now() {
        return new Date();
    }

    /**
     * 获取当前时间的毫秒数
     */
    public static long nowMillis() {
        return System.currentTimeMillis();
    }

    /**
     * 字符串转换成日期
     */
    public static Date StrToDate(String str) {
        Date result=StrToDate(str,"yyyy-MM-dd HH:mm:ss");
        if(result==null){
            return StrToDate(str,"yyyy-MM-dd");
        }
        return result;
    }
    /**
     * 字符串转换成日期
     */
    public static Date StrToDate(String str, String fm) {
        if (StringUtils.isEmpty(fm)) fm = "yyyy-MM-dd HH:mm:ss";
        if (str != null) {
            SimpleDateFormat format = new SimpleDateFormat(fm);
            Date date = null;
            try {
                date = format.parse(str);
            } catch (ParseException e) {
                //log.error("", e);
            }
            return date;
        } else {
            return null;
        }
    }

    /**
     * 定时任务 日期时间转con格式
     */
    public static String taskDateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("s m H d M ? yyyy");
        Date now = new Date();
        String cron = null;
        if (now.getTime() > date.getTime()) {
            cron = sdf.format(new Date(now.getTime() + 5000));
        } else {
            cron = sdf.format(date);
        }
        return cron;
    }
    /**
     * 格式化日期
     * */
    public static String formatDate(Date sourceDate, String format){
        if(sourceDate==null){
            return "";
        }
        if(format.isEmpty())
            format="yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat=new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();//创建一个实例
        calendar.setTime(sourceDate);//实例化一个Calendar。 年、月、日、时、分、秒
        return dateFormat.format(calendar.getTime());
    }
    /**
     * 得到指定日期加上指定类型的时间
     * */
    public static Date getAddDate(Date sourceDate,int type,int count){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(type,count);
        return calendar.getTime();
    }
    /**
     * 得到指定日期加上指定天数的日期
     * */
    public static Date getAddDateByDay(Date sourceDate,int day){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(Calendar.DATE,day);
        return calendar.getTime();
    }
    /**
     * 得到指定日期加上指定天数的日期
     * */
    public static Date getAddDateByMonth(Date sourceDate,int month){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(Calendar.MONTH,month);
        return calendar.getTime();
    }
    /**
     * 得到指定日期加上指定天数的日期
     * */
    public static Date getAddDateByYear(Date sourceDate,int year){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(Calendar.YEAR,year);
        return calendar.getTime();
    }
    /**
     * 得到指定日期加上指定秒数的日期
     * */
    public static Date getAddDateBySecond(Date sourceDate,int second){
        Calendar calendar = Calendar.getInstance();//创建一个实例
        calendar.setTime(sourceDate);//实例化一个Calendar。 年、月、日、时、分、秒
        calendar.add(Calendar.SECOND,second);//给当前日期加上指定天数，这里加的是秒
        return calendar.getTime();
    }

    /**
     * 得到指定日期加上指定秒数的日期
     * */
    public static String getAddDateBySecond(Date sourceDate,int second,String format){
        if(format.isEmpty())
            format="yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat=new SimpleDateFormat(format);
        return dateFormat.format(getAddDateBySecond(sourceDate,second));
    }
    public static Date getDateFromString(String k, String dateformat) {

        if(dateformat.isEmpty())
            dateformat="yyyy-MM-dd HH:mm:ss";
        try {
            SimpleDateFormat format=new SimpleDateFormat(dateformat);
            format.setLenient(false);
            return format.parse(k);
        } catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateFromString(String k) {
        Date s= getDateFromString(k,"yyyy-MM-dd HH:mm:ss");
        if(s==null){
           return getDateFromString(k,"yyyy-MM-dd");
        }
        return s;
    }

    public static boolean checkDate(String k,String dateformat) {

        return getDateFromString(k,dateformat)==null?false:true;
    }
    /**
     * 日期时间比较
     * @param sdate
     * @param edate
     * @return =0两个相等，>0表示开始日期小于结束日期，<0表示开始日期大于结束日期
     */
    public static long dateTimeCompare(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())
                    /1000;
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    /**
     * 日期比较
     * @param sdate
     * @param edate
     * @return =0两个相等，>0表示开始日期小于结束日期，<0表示开始日期大于结束日期
     */
    public static long dateCompare(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())/(24 * 60 * 60 * 1000);
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    /**
     * 日期比较
     * @param sdate
     * @param edate
     * @return =0两个相等，>0表示开始日期小于结束日期，<0表示开始日期大于结束日期
     */
    public static long dateTimeCompare(Date sdate,Date edate) {
        long day = (edate.getTime() - sdate.getTime()) /1000;
        return day;
    }
    public static long getDateDiffSecond(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())
                    /1000;
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    public static long getDateDiffSecond(Date sdate,Date edate) {
        long day = 0;
        try {
            day = (edate.getTime() - sdate.getTime())
                    /1000;
        } catch (Exception e) {
            return -1;
        }
        return day;
    }
    /** * 获取指定日期是星期几

     * 参数为null时表示获取当前日期是星期几

     * @param date

     * @return

     */
    public static String getWeekOfDate(Date date) {

        String[] weekOfDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};

        Calendar calendar = Calendar.getInstance();

        if(date != null){

            calendar.setTime(date);

        }

        int w = calendar.get(Calendar.DAY_OF_WEEK) - 1;

        if (w < 0){

            w = 0;

        }
        return weekOfDays[w];
    }
    public static int getWeekIndexOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        if(date != null){
            calendar.setTime(date);
        }
        int w = calendar.get(Calendar.DAY_OF_WEEK)-1;
        if (w < 0){
            w = 0;
        }
        //return w==0?7:w;
        return w;
    }
    public static String getWeekOfDate(int weekIndex) {

        String[] weekOfDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
        if(weekIndex>=0&&weekIndex<=6) {
            return weekOfDays[weekIndex];
        }
        return "";
    }
    public static String getShortWeekOfDate(int weekIndex){
        String s=getWeekOfDate(weekIndex);
        return s.replace("星期","周");
    }
    public static String getShortWeekOfDate(Date date){
        String s=getWeekOfDate(date);
        return s.replace("星期","周");
    }
    /**
     * 格式化日期为中文格式
     * @param SourceDate
     * @param format
     * @return
     */
    public static String formatDateChina(String SourceDate, String format){
        Date d= new Date(dateToTimestamp(SourceDate) * 1000);
        if(format.isEmpty())
            format="MM月dd日";
        SimpleDateFormat dateFormat=new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();//创建一个实例
        calendar.setTime(d);//实例化一个Calendar。 年、月、日、时、分、秒
        return dateFormat.format(calendar.getTime());
    }
    public static long dateToTimestamp(String dateString)  {
        return dateToTimestamp(dateString,"yyyy-MM-dd HH:mm:ss");
    }
    public static long dateToTimestamp(String dateString,String format)  {
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            Date date;
            try {
                date = df.parse(dateString);
            }catch (ParseException e){
                df = new SimpleDateFormat("yyyy-MM-dd");
                date = df.parse(dateString);
            }
            long s = date.getTime();
            return (s / 1000);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return 0;
    }
    public static String getDateName(String date){
        if(date==null||date.isEmpty()){
            return "7日后";
        }
        //String[] s = new String[]{"今日","明日","后日","三日","四日","五日","六日","七日","八日","九日","十日后"};
        int l=(int)DateUtils.getDateDiff(DateUtils.date(),date);
        if(l==0){
            return "今日";
        }
        if(l==1){
            return "明日";
        }
        if(l==2){
            return "后日";
        }

        return formatDateChina(date,"M月d日");

    }
    public static long getDateDiff(String sdate,String edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date;
            Date end_date;
            begin_date = format.parse(sdate);
            end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime())
                    / (24 * 60 * 60 * 1000);
        } catch (Exception e) {
            return -1;
        }
        return day;
    }

    public static long getDateDiff(Date sdate,Date edate) {
        long day = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = format.format(sdate);
            String endDate = format.format(edate);
            return getDateDiff(startDate,endDate);
        } catch (Exception e) {
            return -1;
        }
    }
    public static Date getDate(Date date){
        // date变量含有日期和时间，写得到日期的方法
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String s = sdf.format(date);
        try {
            return sdf.parse(s);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
    public static String getTime(Date date){
        // date变量含有日期和时间，写得到时间的方法
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String s = sdf.format(date);
        return s;
    }
    public static int getQuarter(Date date){
        Calendar cal = Calendar.getInstance();
        int m = cal.get(Calendar.MONTH) + 1;
        Integer quarter =0;
        if (m >= 1 && m <= 3) {
            quarter = 1;
        }
        if (m >= 4 && m <= 6) {
            quarter = 2;
        }
        if (m >= 7 && m <= 9) {
            quarter = 3;
        }
        if (m >= 10 && m <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static Set<Integer> getWeekOfQuarter(Date date){
        Set<Integer> r=new HashSet<>();
        Date sdate=getCurrentQuarterStartTime(date);
        Date edate=getCurrentQuarterEndTime(date);
        Integer sweek=getWeekOfYear(sdate);
        Integer eweek=getWeekOfYear(edate);
        for(int i=sweek;i<=eweek;i++){
            r.add(i);
        }
        return r;
    }
    public static Integer getWeekOfYear(Date date){
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.WEEK_OF_YEAR);
    }
    public static Integer getYear(Date date){
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.YEAR);
    }
    public static Integer getMonth(Date date){
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.MONTH);
    }
    public static Integer getDay(Date date){
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.DATE);
    }
    public static Integer getWeekOfMonth(Date date){
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.WEEK_OF_MONTH);
    }
    public static boolean isMonthLastWeek(Date weekFirstDate){
        if(weekFirstDate.compareTo(DateUtils.StrToDate("2021-02-01","yyyy-MM-dd"))==0){
            return true;
        }
        if(weekFirstDate.compareTo(DateUtils.StrToDate("2021-01-25","yyyy-MM-dd"))==0){
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(weekFirstDate);
        int day1=c.get(Calendar.DAY_OF_MONTH) + 1;
        int lastDay = c.getActualMaximum(Calendar.DATE);//月的最后一天

        Date s=DateUtils.getAddDateByDay(weekFirstDate,6);//周日
        c.setTime(s);
        int day2 = c.get(Calendar.DAY_OF_MONTH) ;
        if(day1<day2){
            if(day2+3>=lastDay){
                System.out.println("========================================="+weekFirstDate+" -true ");
                return true;
            }
            return false;
        }else {
            if(day2-3<1){
                System.out.println("========================================="+weekFirstDate+" -true ");
                return true;
            }
        }




        return day2<4;
    }
    /**
     * 当前季度的开始时间
     *
     * @return
     */
    public static Date getCurrentQuarterStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3)
                c.set(Calendar.MONTH, 0);
            else if (currentMonth >= 4 && currentMonth <= 6)
                c.set(Calendar.MONTH, 3);
            else if (currentMonth >= 7 && currentMonth <= 9)
                c.set(Calendar.MONTH, 4);
            else if (currentMonth >= 10 && currentMonth <= 12)
                c.set(Calendar.MONTH, 9);
            c.set(Calendar.DATE, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    /**
     * 当前季度的结束时间
     *
     * @return
     */
    public static Date getCurrentQuarterEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(Calendar.MONTH, 2);
                c.set(Calendar.DATE, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(Calendar.MONTH, 5);
                c.set(Calendar.DATE, 30);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(Calendar.MONTH, 8);
                c.set(Calendar.DATE, 30);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(Calendar.MONTH, 11);
                c.set(Calendar.DATE, 31);
            }
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    /**
     * 距当天结束还剩多少秒
     * @param currentDate
     * @return
     */
    public static long getRemainSecondsOneDay(Date currentDate) {
        LocalDateTime midnight = LocalDateTime.ofInstant(currentDate.toInstant(),
                ZoneId.systemDefault()).plusDays(1).withHour(0).withMinute(0)
                .withSecond(0).withNano(0);
        LocalDateTime currentDateTime = LocalDateTime.ofInstant(currentDate.toInstant(),
                ZoneId.systemDefault());
        long seconds = ChronoUnit.SECONDS.between(currentDateTime, midnight);
        return seconds;
    }
    public static Integer dayForWeek(Date pTime)  {

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        Integer[] weekDays = { 7, 1, 2, 3, 4, 5, 6};
        try {
            cal.setTime(pTime);
        } catch (Exception e) {

            e.printStackTrace();

        }
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1; // 指示一个星期中的某天。
        if (w < 0)
            w = 0;
        return weekDays[w];

    }
    public static Integer getCurrentHour(){
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.HOUR_OF_DAY); // 24小时制
    }
    public static Integer getCurrentMinute(){
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.MINUTE); //
    }
    public static Date getCurrentMonthFirstDay(Date date){
        // 创建 Calendar 对象并设置为当前时间
        Calendar calendar = Calendar.getInstance();
        if(date!=null){
            calendar.setTime(date);
        }
        // 将日期设置为本月第一天
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        // 输出结果
        return calendar.getTime();
    }
    public static Date getCurrentMonthFirstDay(){
        return getCurrentMonthFirstDay(null);
    }
    public static Date getCurrentMonthLastDay(Date date){
        // 创建 Calendar 对象并设置为当前日期时间
        Calendar calendar = Calendar.getInstance();
        if(date!=null){
            calendar.setTime(date);
        }
        // 将日期设置为本月第一天
        calendar.set(Calendar.DAY_OF_MONTH, 1);

        // 将日期设置为下个月第一天
        calendar.add(Calendar.MONTH, 1);
        calendar.set(Calendar.DAY_OF_MONTH, 1);

        return getAddDateByDay( calendar.getTime(),-1);
    }
    public static Date getCurrentMonthLastDay(){
        return getCurrentMonthLastDay(null);
    }
    public static Date getDateByISOString(String dateStr) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'+08:00'");
        Date date = null;
        try{
            date = format.parse(dateStr);
            return date;
        } catch (ParseException e) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            try{
                date = format.parse(dateStr);
                return date;
            } catch (ParseException e1) {
                format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
                date = format.parse(dateStr);
                return date;
            }
        }
    }
    public static String getISOStringByDate(Date date) throws ParseException {
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return s.format(date);
    }

}
