/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.login;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LoginUtils {
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private MemcachedService memcachedService;
    @Value(value="${app.id:#{NULL}}")
    private String appId;
    private static final Logger log = LoggerFactory.getLogger(LoginUtils.class);

    public Map<String, String> getUserMap() throws AuthorizeException {
        BaseJsonVo jsonVo;
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if (req == null) {
            log.info("\u8bf7\u6c42request \u4e3a\u7a7a");
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        String testAuthor = req.getParameter("testAuthor");
        if (StringUtils.isEmpty(testAuthor)) {
            testAuthor = req.getHeader("testAuthor");
        }
        if ((jsonVo = this.checkTestAuthor(testAuthor)).isSuccess()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", testAuthor.split("_")[0]);
            map.put("userName", "test");
            map.put("userNick", "test");
            return map;
        }
        String key = "JSESSIONID";
        Cookie cookie = CookieUtils.getCookie(req, "JSESSIONID");
        if (cookie == null) {
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        String jsessionid = cookie.getValue();
        if (StringUtils.isEmpty(jsessionid)) {
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        Object user = null;
        try {
            user = this.redisCacheUtil.get(key + jsessionid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user == null) {
            try {
                user = this.memcachedService.get(key + jsessionid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (user == null) {
            log.info("memcachedService\u83b7\u53d6\u7528\u6237\u4e3a\u7a7a");
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        return (Map)user;
    }

    public Boolean isLogin() {
        try {
            Map<String, String> map = this.getUserMap();
            if (map != null) {
                return true;
            }
        }
        catch (AuthorizeException authorizeException) {
            // empty catch block
        }
        return false;
    }

    public MallUserEntity getLoginUser() {
        try {
            return this.getUser();
        }
        catch (AuthorizeException authorizeException) {
            return null;
        }
    }

    public String getLoginUserId() {
        try {
            return this.getUser().getUserId();
        }
        catch (AuthorizeException authorizeException) {
            return null;
        }
    }

    public MallUserEntity getUser() throws AuthorizeException {
        try {
            Map<String, String> map = this.getUserMap();
            return ObjectConvert.mapConvertToObject(map, MallUserEntity.class);
        }
        catch (Exception e) {
            log.error("getUser\u767b\u5f55\u5f02\u5e38:", (Throwable)e);
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
    }

    public static void main(String[] args) {
        String path = "https://gatewaytest.lechun.cc/lechun-tools/app/getAppList?pageSize=20&pageNum=1&pageRouterUrl=%2Fdashboard";
        String[] paths = path.split("/");
        if (paths.length < 4) {
            System.out.println("\u9519\u8bef");
        }
        System.out.println(paths[3]);
    }

    public BaseJsonVo checkTestAuthor(String author) {
        String sys;
        String key;
        Object value;
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if (req == null) {
            return BaseJsonVo.error("\u7528\u6237\u672a\u767b\u9646");
        }
        String path = req.getRequestURL().toString().toLowerCase();
        if (StringUtils.isEmpty(path) || StringUtils.isEmpty(author)) {
            return BaseJsonVo.error("\u8ba4\u8bc1\u4e3a\u7a7a");
        }
        log.info("\u8bf7\u6c42\u8def\u5f84\uff1a" + path);
        log.info("\u8bf7\u6c42appID\uff1a" + this.appId);
        if (StringUtils.isEmpty(this.appId)) {
            String[] paths = path.split("/");
            if (paths.length < 4) {
                return BaseJsonVo.error("\u8ba4\u8bc1\u9519\u8bef");
            }
            this.appId = paths[3];
            log.info("\u8bf7\u6c42appID1\uff1a" + this.appId);
        }
        if ((value = this.redisCacheUtil.get((key = (sys = this.appId) + "_" + author.split("_")[0]).toLowerCase(Locale.ROOT))) != null) {
            if (author.equals(value.toString())) {
                return BaseJsonVo.success("");
            }
        } else {
            String[] arr = sys.split("-");
            if (arr.length > 1) {
                sys = arr[1];
            }
            if ((value = this.redisCacheUtil.get((key = sys + "_" + author.split("_")[0]).toLowerCase(Locale.ROOT))) != null && author.equals(value.toString())) {
                return BaseJsonVo.success("");
            }
        }
        return BaseJsonVo.error("\u8ba4\u8bc1\u9519\u8bef");
    }
}

