/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.math;

import cc.lechun.framework.common.utils.date.DateUtils;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CompareUtil {
    private static void main(String[] args) {
        boolean b = CompareUtil.Compare(12, "12", "13", "between");
        System.out.println("jiekou:" + b);
    }

    public static boolean Compare(Object mapValue, String filterValue, String filterValue1, String filterType) {
        if (StringUtil.isEmpty((String)filterType)) {
            return false;
        }
        filterType = filterType.toUpperCase(Locale.ROOT).trim();
        try {
            String value0 = null;
            String value = null;
            String value1 = null;
            if (mapValue instanceof Date) {
                if (StringUtil.isNotEmpty((String)filterValue)) {
                    value = String.valueOf(DateUtils.StrToDate(filterValue).getTime());
                }
                if (StringUtil.isNotEmpty((String)filterValue1)) {
                    value1 = String.valueOf(DateUtils.StrToDate(filterValue1).getTime());
                }
                if (mapValue != null) {
                    value0 = String.valueOf(((Date)mapValue).getTime());
                }
                return CompareUtil.Compare(value0, value, value1, filterType);
            }
            if (mapValue != null) {
                value0 = mapValue.toString();
            }
            return CompareUtil.Compare(value0, filterValue, filterValue1, filterType);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static <T> boolean Compare(String mapValue, String filterValue, String filterValue1, String filterType) {
        try {
            if (filterType.equals("EQUALS")) {
                if (filterValue == null) {
                    return false;
                }
                return filterValue.equals(mapValue);
            }
            if (filterType.equals("NOT_EQUALS")) {
                if (filterValue == null) {
                    return false;
                }
                return !filterValue.equals(mapValue);
            }
            if (">".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return Double.parseDouble(mapValue) > Double.parseDouble(filterValue);
            }
            if ("<".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return Double.parseDouble(mapValue) < Double.parseDouble(filterValue);
            }
            if ("=".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return Double.parseDouble(mapValue) == Double.parseDouble(filterValue);
            }
            if ("<=".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return Double.parseDouble(mapValue) <= Double.parseDouble(filterValue);
            }
            if (">=".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return Double.parseDouble(mapValue) >= Double.parseDouble(filterValue);
            }
            if ("!=".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return Double.parseDouble(mapValue) != Double.parseDouble(filterValue);
            }
            if ("LIKE".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return mapValue.indexOf(filterValue) > -1;
            }
            if ("NOT_LIKE".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                return mapValue.indexOf(filterValue) < 0;
            }
            if ("IN".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                String[] filterValues = filterValue.split(",");
                return Arrays.stream(filterValues).filter(c -> c.equals(mapValue)).count() > 0L;
            }
            if ("NOT_IN".equals(filterType)) {
                if (filterValue == null || mapValue == null) {
                    return false;
                }
                String[] filterValues = filterValue.split(",");
                return Arrays.stream(filterValues).filter(c -> c.equals(mapValue)).count() <= 0L;
            }
            if ("BETWEEN".equals(filterType)) {
                if (mapValue == null) {
                    return false;
                }
                if (StringUtil.isEmpty((String)filterValue) && StringUtil.isEmpty((String)filterValue1)) {
                    return Double.parseDouble(mapValue) <= Double.parseDouble(filterValue1);
                }
                if (StringUtil.isEmpty((String)filterValue1) && StringUtil.isNotEmpty((String)filterValue)) {
                    return Double.parseDouble(mapValue) >= Double.parseDouble(filterValue);
                }
                return Double.parseDouble(mapValue) >= Double.parseDouble(filterValue) && Double.parseDouble(mapValue) <= Double.parseDouble(filterValue1);
            }
            if ("NOT_BETWEEN".equals(filterType)) {
                if (mapValue == null) {
                    return false;
                }
                if (StringUtil.isEmpty((String)filterValue) && StringUtil.isNotEmpty((String)filterValue1)) {
                    return Double.parseDouble(mapValue) > Double.parseDouble(filterValue1);
                }
                if (StringUtil.isEmpty((String)filterValue1) && StringUtil.isNotEmpty((String)filterValue)) {
                    return Double.parseDouble(mapValue) < Double.parseDouble(filterValue);
                }
                return Double.parseDouble(mapValue) < Double.parseDouble(filterValue) && Double.parseDouble(mapValue) > Double.parseDouble(filterValue1);
            }
            if ("NULL".equals(filterType)) {
                return StringUtil.isEmpty((String)mapValue);
            }
            if ("NOT_NULL".equals(filterType)) {
                return StringUtil.isNotEmpty((String)mapValue);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static List<Map<String, Object>> getCompareString(String dataType) {
        ArrayList<Map<String, Object>> filterList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("code", "NULL");
        filterMap.put("name", "\u4e3a\u7a7a");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        filterMap = new HashMap();
        filterMap.put("code", "NOT_NULL");
        filterMap.put("name", "\u4e0d\u4e3a\u7a7a");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        if (dataType.equals("String")) {
            filterMap = new HashMap();
            filterMap.put("code", "EQUALS");
            filterMap.put("name", "\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "NOT_EQUALS");
            filterMap.put("name", "\u4e0d\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "LIKE");
            filterMap.put("name", "\u5305\u542b(like)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "NOT_LIKE");
            filterMap.put("name", "\u4e0d\u5305\u542b(not like)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "IN");
            filterMap.put("name", "\u5305\u542b(IN,\u591a\u4e2a\u9017\u53f7\u5206\u9694)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "NOT IN");
            filterMap.put("name", "\u4e0d\u5305\u542b(NOT IN,\u591a\u4e2a\u9017\u53f7\u5206\u9694)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
        } else {
            filterMap = new HashMap();
            filterMap.put("code", ">");
            filterMap.put("name", "\u5927\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", ">=");
            filterMap.put("name", "\u5927\u4e8e\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "<");
            filterMap.put("name", "\u5c0f\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "<=");
            filterMap.put("name", "\u5c0f\u4e8e\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "=");
            filterMap.put("name", "\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "!=");
            filterMap.put("name", "!\u4e0d\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "BETWEEN");
            filterMap.put("name", "\u5728\u4e24\u8005\u4e4b\u95f4");
            filterMap.put("inputNum", 2);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", "NOT_BETWEEN");
            filterMap.put("name", "\u4e0d\u5728\u4e24\u8005\u4e4b\u95f4");
            filterMap.put("inputNum", 2);
            filterList.add(filterMap);
        }
        return filterList;
    }

    public static String getSqlOperator(Integer operator) {
        switch (operator) {
            case 1: {
                return "IS NULL";
            }
            case 2: {
                return "IS NOT NULL";
            }
            case 3: {
                return "=";
            }
            case 4: {
                return "!=";
            }
            case 5: {
                return "LIKE";
            }
            case 6: {
                return "NOT LIKE";
            }
            case 7: {
                return "IN";
            }
            case 8: {
                return "NOT IN";
            }
            case 9: {
                return ">";
            }
            case 10: {
                return ">=";
            }
            case 11: {
                return "<";
            }
            case 12: {
                return "<=";
            }
            case 13: {
                return "BETWEEN";
            }
            case 14: {
                return "NOT BETWEEN";
            }
            case 1000: {
                return "ASC";
            }
            case 1001: {
                return "DESC";
            }
        }
        return "=";
    }

    public static List<Map<String, Object>> getSqlCompareString(String dataType) {
        ArrayList<Map<String, Object>> filterList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("code", 1);
        filterMap.put("name", "\u4e3a\u7a7a");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        filterMap = new HashMap();
        filterMap.put("code", 2);
        filterMap.put("name", "\u4e0d\u4e3a\u7a7a");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        if (dataType.equals("String") || dataType.contains("char") || dataType.contains("text")) {
            filterMap = new HashMap();
            filterMap.put("code", 3);
            filterMap.put("name", "\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 4);
            filterMap.put("name", "\u4e0d\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 5);
            filterMap.put("name", "\u5305\u542b(like)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 6);
            filterMap.put("name", "\u4e0d\u5305\u542b(not like)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 7);
            filterMap.put("name", "\u5305\u542b(IN,\u591a\u4e2a\u9017\u53f7\u5206\u9694)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 8);
            filterMap.put("name", "\u4e0d\u5305\u542b(NOT IN,\u591a\u4e2a\u9017\u53f7\u5206\u9694)");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
        } else {
            filterMap = new HashMap();
            filterMap.put("code", 9);
            filterMap.put("name", "\u5927\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 10);
            filterMap.put("name", "\u5927\u4e8e\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 11);
            filterMap.put("name", "\u5c0f\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 12);
            filterMap.put("name", "\u5c0f\u4e8e\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 3);
            filterMap.put("name", "\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 4);
            filterMap.put("name", "!\u4e0d\u7b49\u4e8e");
            filterMap.put("inputNum", 1);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 13);
            filterMap.put("name", "\u5728\u4e24\u8005\u4e4b\u95f4");
            filterMap.put("inputNum", 2);
            filterList.add(filterMap);
            filterMap = new HashMap();
            filterMap.put("code", 14);
            filterMap.put("name", "\u4e0d\u5728\u4e24\u8005\u4e4b\u95f4");
            filterMap.put("inputNum", 2);
            filterList.add(filterMap);
        }
        return filterList;
    }

    public static List<Map<String, Object>> getSqlOrderByString() {
        ArrayList<Map<String, Object>> filterList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("code", 1000);
        filterMap.put("name", "\u5347\u5e8f");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        filterMap = new HashMap();
        filterMap.put("code", 1001);
        filterMap.put("name", "\u964d\u5e8f");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        return filterList;
    }
}

