/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.file;

import cc.lechun.framework.common.utils.ReflectUtil;
import cc.lechun.framework.common.utils.date.DateFormatUtil;
import cc.lechun.framework.common.vo.ExportVo;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.TextAlignment;
import jakarta.servlet.ServletOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class ExportPdfUtil {
    public static <T> boolean export(ExportVo<T> exportVO, ServletOutputStream out) {
        String[] headers = exportVO.getHeaders();
        String[] fieldNames = exportVO.getFieldNames();
        float[] columnWidth = new float[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            columnWidth[i] = headers[i].length();
        }
        try {
            PdfDocument pdf = new PdfDocument(new PdfWriter((OutputStream)out));
            PageSize ps = new PageSize(842.0f, 680.0f);
            Document document = new Document(pdf, ps);
            PdfFont headerFont = PdfFontFactory.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            PdfFont bodyFont = PdfFontFactory.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Table table = new Table(columnWidth);
            ((Table)((Table)table.setWidthPercent(100.0f)).setTextAlignment(TextAlignment.CENTER)).setHorizontalAlignment(HorizontalAlignment.CENTER);
            for (int i = 0; i < headers.length; ++i) {
                Cell cell = new Cell().add((BlockElement)new Paragraph(headers[i]));
                ((Cell)((Cell)cell.setFont(headerFont)).setBorder((Border)new SolidBorder(Color.BLACK, 0.5f))).setFontSize(14.0f);
                table.addHeaderCell(cell);
            }
            Class<?> cls = null;
            Object t2 = null;
            for (Object t2 : exportVO.getDataset()) {
                int i;
                if (t2 instanceof HashMap) {
                    for (i = 0; i < fieldNames.length; ++i) {
                        Object value = ((HashMap)t2).get(fieldNames[i]);
                        if (null != value && value instanceof Double) {
                            b = new BigDecimal((Double)value);
                            value = b.setScale(3, 6).doubleValue();
                        } else if (null != value && value instanceof BigDecimal) {
                            b = new BigDecimal(value.toString());
                            value = b.setScale(3, 6).doubleValue();
                        }
                        Cell cell = new Cell().add((BlockElement)new Paragraph(ExportPdfUtil.handleValue(value, exportVO.getDatePattern())));
                        ((Cell)((Cell)cell.setFont(bodyFont)).setBorder((Border)new SolidBorder(Color.BLACK, 0.5f))).setFontSize(8.0f);
                        table.addCell(cell);
                    }
                    continue;
                }
                cls = t2.getClass();
                for (i = 0; i < fieldNames.length; ++i) {
                    String fieldName = fieldNames[i];
                    String getMethodName = ReflectUtil.getMethodName(fieldName, "get");
                    Method method = cls.getMethod(getMethodName, new Class[0]);
                    Object value = method.invoke(t2, new Object[0]);
                    if (null != value && value instanceof Double) {
                        b = new BigDecimal((Double)value);
                        value = b.setScale(3, 6).doubleValue();
                    } else if (null != value && value instanceof BigDecimal) {
                        b = new BigDecimal(value.toString());
                        value = b.setScale(3, 6).doubleValue();
                    }
                    Cell cell = new Cell().add((BlockElement)new Paragraph(ExportPdfUtil.handleValue(value, exportVO.getDatePattern())));
                    ((Cell)((Cell)cell.setFont(bodyFont)).setBorder((Border)new SolidBorder(Color.BLACK, 0.5f))).setFontSize(8.0f);
                    table.addCell(cell);
                }
            }
            document.add((BlockElement)table);
            document.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String handleValue(Object value, String datePattern) {
        String textValue = "";
        if (value instanceof Date) {
            Date date = (Date)value;
            textValue = DateFormatUtil.date2Str(date, datePattern);
        } else {
            textValue = value == null ? "" : value.toString();
        }
        return textValue;
    }
}

