/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.serviceresult;

import com.github.pagehelper.Page;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StatisticsResult {
    public static Page<Map<String, Object>> statisticsByParam(int pageNum, int pageSize, List<Map<String, Object>> resultList, List<String> paramList, List<String> groupKeyList) {
        Page returnList = new Page(pageNum, pageSize);
        List<Object> list = new ArrayList();
        if (!(paramList == null || paramList.isEmpty() || resultList == null || resultList.isEmpty() || groupKeyList == null || groupKeyList.isEmpty())) {
            list = StatisticsResult.statisticsByParamList(resultList, paramList, groupKeyList);
            returnList.addAll(list);
        }
        Page subResults = new Page(pageNum, pageSize);
        subResults.setTotal((long)returnList.size());
        subResults.setPageNum(pageNum);
        subResults.setPages(returnList.size() / pageSize + 1);
        int startNum = 1 + (pageNum - 1) * pageSize;
        subResults.setStartRow((long)startNum);
        int endNum = pageNum * pageSize > returnList.size() ? returnList.size() : pageNum * pageSize;
        subResults.setEndRow((long)endNum);
        for (int i = startNum; i <= endNum; ++i) {
            subResults.add((Object)((Map)returnList.get(i - 1)));
        }
        return subResults;
    }

    public static List<Map<String, Object>> statisticsByParamList(List<Map<String, Object>> resultList, List<String> paramList, List<String> groupKeyList) {
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>();
        if (paramList == null || paramList.isEmpty() || resultList == null || resultList.isEmpty() || groupKeyList == null || groupKeyList.isEmpty()) {
            return null;
        }
        String groupKeyName = groupKeyList.get(0);
        HashSet allGroupName = Sets.newHashSet();
        for (Map<String, Object> map : resultList) {
            String key = (String)map.get(groupKeyName);
            allGroupName.add(key);
        }
        for (String groupKey : allGroupName) {
            if (groupKey == null) {
                groupKey = "";
            }
            HashMap resultMap = Maps.newHashMap();
            for (Map<String, Object> map : resultList) {
                boolean addFlag = false;
                for (String statisticsField : paramList) {
                    String groupValue = (String)map.get(groupKeyName) == null ? "" : (String)map.get(groupKeyName);
                    if (!groupValue.equals(groupKey)) continue;
                    addFlag = true;
                    Object statisticsValue = map.get(statisticsField);
                    BigDecimal value = new BigDecimal("0");
                    if (statisticsValue != null) {
                        if (statisticsValue instanceof Long) {
                            value = new BigDecimal((Long)statisticsValue);
                        }
                        if (statisticsValue instanceof BigDecimal) {
                            value = (BigDecimal)statisticsValue;
                        }
                        if (statisticsValue instanceof Double) {
                            value = new BigDecimal((Double)statisticsValue);
                        }
                        if (statisticsValue instanceof Float) {
                            value = new BigDecimal(((Float)statisticsValue).floatValue());
                        }
                        if (statisticsValue instanceof String) {
                            value = new BigDecimal((String)statisticsValue);
                        }
                    }
                    BigDecimal totalValue = resultMap.get(statisticsField) == null ? new BigDecimal("0") : (BigDecimal)resultMap.get(statisticsField);
                    totalValue = totalValue.add(value);
                    resultMap.put(statisticsField, totalValue);
                }
                if (!addFlag) continue;
                returnList.add(map);
            }
            resultMap.put(groupKeyName, "\u5c0f\u8ba1");
            returnList.add(resultMap);
        }
        return returnList;
    }
}

