/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.web;

import com.alibaba.fastjson.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static void corsConfig(HttpServletRequest request, HttpServletResponse httpServletResponse) {
        String curOrigin = request.getHeader("Origin");
        if (!StringUtils.isEmpty((String)curOrigin)) {
            httpServletResponse.setHeader("Access-Control-Allow-Origin", curOrigin);
            httpServletResponse.setHeader("Access-Control-Allow-Credentials", "true");
        }
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json; charset=utf-8");
        if (request.getMethod().equals("OPTIONS")) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "*");
            httpServletResponse.setHeader("Access-Control-Allow-Headers", "Content-Type,Access-Token");
            httpServletResponse.setHeader("Access-Control-Expose-Headers", "*");
        }
    }

    public static void corsConfigFilter(HttpServletRequest request, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "POST, PUT, GET, OPTIONS, DELETE");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type,Access-Token,Authorization, Content-Type,X-Requested-With,Pagerouterurl,testAuthor");
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setStatus(200);
        }
    }

    public static void corsConfigFilter(ServerHttpRequest request, ServerHttpResponse response) {
        response.getHeaders().add("Content-Type", "application/json; charset=utf-8");
        response.getHeaders().add("Access-Control-Allow-Origin", request.getHeaders().getFirst("Origin"));
        response.getHeaders().add("Access-Control-Allow-Credentials", "true");
        response.getHeaders().add("Access-Control-Allow-Methods", "POST, PUT, GET, OPTIONS, DELETE");
        response.getHeaders().add("Access-Control-Allow-Headers", "Content-Type,Access-Token,Authorization, Content-Type,X-Requested-With,Pagerouterurl,testAuthor");
        if ("OPTIONS".equalsIgnoreCase(request.getMethod().name().toString())) {
            response.setStatusCode(HttpStatusCode.valueOf((int)200));
        }
    }

    public static void writeCorsJsonDate(HttpServletRequest request, HttpServletResponse httpServletResponse, Object obj) throws IOException {
        ResponseUtils.corsConfig(request, httpServletResponse);
        httpServletResponse.getWriter().print(JSON.toJSONString((Object)obj));
    }
}

