/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XmlUtils {
    public static SortedMap doXMLParseSort(String strxml) {
        if (null == (strxml = strxml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")) || "".equals(strxml)) {
            return null;
        }
        TreeMap<String, String> m = new TreeMap<String, String>();
        InputStream in = XmlUtils.String2Inputstream(strxml);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        List list = root.getChildren();
        for (Element e : list) {
            String k = e.getName();
            String v = "";
            List children = e.getChildren();
            v = children.isEmpty() ? e.getTextNormalize() : XmlUtils.getChildrenText(children);
            m.put(k, v);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Map doXMLParse(String strxml) {
        if (null == (strxml = strxml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")) || "".equals(strxml)) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        InputStream in = XmlUtils.String2Inputstream(strxml);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        List list = root.getChildren();
        for (Element e : list) {
            String k = e.getName();
            String v = "";
            List children = e.getChildren();
            v = children.isEmpty() ? e.getTextNormalize() : XmlUtils.getChildrenText(children);
            m.put(k, v);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static String getChildrenText(List children) {
        StringBuffer sb = new StringBuffer();
        if (!children.isEmpty()) {
            for (Element e : children) {
                String name = e.getName();
                String value = e.getTextNormalize();
                List list = e.getChildren();
                sb.append("<" + name + ">");
                if (!list.isEmpty()) {
                    sb.append(XmlUtils.getChildrenText(list));
                }
                sb.append(value);
                sb.append("</" + name + ">");
            }
        }
        return sb.toString();
    }

    public static InputStream String2Inputstream(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    public Object xml2Object(String inputXml, Class<?> type, String alias) {
        if (null == inputXml || "".equals(inputXml)) {
            return null;
        }
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
            xstream.alias(alias, type);
            return xstream.fromXML(inputXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

