/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class StringUtils {
    public static String clean(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String deleteWhitespace(String str) {
        StringBuffer buffer = new StringBuffer();
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static int getWordCount(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            int ascii = Character.codePointAt(s, i);
            if (ascii >= 0 && ascii <= 255) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length;
    }

    public static boolean checkOpenID(String openId) {
        if (StringUtils.isEmpty(openId)) {
            return false;
        }
        String s = "^[a-zA-Z0-9_\\-]{28}$";
        Pattern pattern = Pattern.compile(s);
        Matcher matcher = pattern.matcher(openId);
        return matcher.matches();
    }

    public static String rePlacePhone(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return phone;
        }
        String p = phone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        return p;
    }

    public static Boolean isNaN(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String unicode2String(String unicode) {
        StringBuffer string = new StringBuffer();
        String[] hex = unicode.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            string.append((char)data);
        }
        return string.toString();
    }

    public static Boolean checkPhone(String phone) {
        String pattern = "^1([3-9][0-9])\\d{8}$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(phone);
        return m.matches();
    }

    public static Boolean checkEmail(String email) {
        String pattern = "\\w[-\\w.+]*@([A-Za-z0-9][-A-Za-z0-9]+\\.)+[A-Za-z]{2,14}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(email);
        return m.matches();
    }

    public static Boolean checkIdcard(String idcard) {
        String pattern = "\\d{17}[0-9Xx]|\\d{15}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(idcard);
        return m.matches();
    }

    public static String getTextFromHtml(String html) {
        Pattern regExStyle = Pattern.compile("<style[^>]*?>[\\s\\S]*?<\\/style>");
        Pattern regExScript = Pattern.compile("<script[^>]*?>[\\s\\S]*?<\\/script>");
        Pattern regExHtml = Pattern.compile("<[^>]+>");
        Pattern regExSpecial = Pattern.compile("&[a-z]+;");
        String script = regExScript.matcher(html).replaceAll("");
        String style = regExStyle.matcher(script).replaceAll("");
        String html1 = regExHtml.matcher(style).replaceAll("");
        return regExSpecial.matcher(html1).replaceAll("");
    }

    public static String cleanResume(String content) {
        String[] strings;
        if (StringUtils.isEmpty(content)) {
            return content;
        }
        content = Jsoup.clean((String)content, (Safelist)Safelist.none());
        content = org.apache.commons.lang3.StringUtils.lowerCase((String)content);
        for (String s : strings = new String[]{" ", "\n", "\r", "\t", "\\r", "\\n", "\\t", "&nbsp;"}) {
            content = content.replaceAll(s, "");
        }
        return content;
    }
}

