/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.advice;

import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class JsonpConfig {
    @Bean
    public MappingJackson2HttpMessageConverter getMappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter(this){
            private static final String CALLBACK = "callback";

            private String parseCallbackParam() {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
                return request.getParameter(CALLBACK);
            }

            protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
                String callback = this.parseCallbackParam();
                if (!StringUtils.isEmpty((Object)callback)) {
                    generator.writeRaw(callback + "(");
                }
            }

            protected void writeSuffix(JsonGenerator generator, Object object) throws IOException {
                String callback = this.parseCallbackParam();
                if (!StringUtils.isEmpty((Object)callback)) {
                    generator.writeRaw(")");
                }
            }
        };
    }
}

