/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.json;

import cc.lechun.framework.common.utils.json.JsonGenerateHandler;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.codehaus.jackson.util.DefaultPrettyPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Set<String> getObjectFields(JsonNode node) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        if (node != null && node.isObject()) {
            Iterator iter = node.getFieldNames();
            while (iter.hasNext()) {
                fields.add((String)iter.next());
            }
        }
        return fields;
    }

    public static Object readValue(JsonParser jp, final Type type) throws IOException {
        return OBJECT_MAPPER.readValue(jp, (TypeReference)new TypeReference<Object>(){

            public Type getType() {
                return type;
            }
        });
    }

    public static void writeValue(JsonGenerator jg, Object o, Boolean human) throws IOException {
        if (human != null && human.booleanValue()) {
            jg.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        }
        OBJECT_MAPPER.writeValue(jg, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJson(Object o, boolean human) {
        StringWriter w = new StringWriter();
        JsonGenerator jg = null;
        try {
            jg = JSON_FACTORY.createJsonGenerator((Writer)w);
            JsonUtils.writeValue(jg, o, human);
            jg.flush();
            String string = w.toString();
            return string;
        }
        catch (IOException e) {
            log.error("\u8f6c\u6362json\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (jg != null) {
                try {
                    jg.close();
                }
                catch (IOException ignored) {
                    log.error("", (Throwable)ignored);
                }
            }
        }
        return "";
    }

    public static String toJson(JsonGenerateHandler h, boolean human) throws IOException {
        StringWriter w = new StringWriter();
        JsonGenerator jg = null;
        try {
            jg = JSON_FACTORY.createJsonGenerator((Writer)w);
            if (human) {
                jg.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            }
            h.generate(jg);
            jg.flush();
            String string = w.toString();
            return string;
        }
        catch (IOException e) {
            throw new IOException("", e);
        }
        finally {
            if (jg != null) {
                try {
                    jg.close();
                }
                catch (IOException ignored) {
                    log.error("", (Throwable)ignored);
                }
            }
        }
    }

    public static <T> T fromJson(String json, Class<T> type) throws IOException {
        return (T)JsonUtils.fromJson(json, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromJson(String json, Type type) throws IOException {
        Object object;
        block10: {
            JsonParser jp = null;
            try {
                jp = JSON_FACTORY.createJsonParser(json);
                object = JsonUtils.readValue(jp, type);
                if (jp == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (jp != null) {
                        try {
                            jp.close();
                        }
                        catch (IOException ignored) {
                            log.error("", (Throwable)ignored);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("\u8f6c\u6362json\u5931\u8d25", e);
                }
            }
            try {
                jp.close();
            }
            catch (IOException ignored) {
                log.error("", (Throwable)ignored);
            }
        }
        return object;
    }

    public static JsonNode parse(String json) throws IOException {
        return JsonUtils.fromJson(json, JsonNode.class);
    }

    public static boolean isValidate(String json) {
        try {
            JsonUtils.parse(json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> List<T> getListByArray(Class<T> class1, String jArrayStr) {
        ArrayList<Object> list = new ArrayList<Object>();
        JSONArray jsonArray = JSONArray.parseArray((String)jArrayStr);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return list;
        }
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            Object t = JSONObject.toJavaObject((JSON)jsonObject, class1);
            list.add(t);
        }
        return list;
    }

    public static Map stringToMap(String s) {
        JSONObject m = JSONObject.parseObject((String)s);
        return m;
    }
}

