/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.object;

import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.springframework.beans.FatalBeanException;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BeanUtils {
    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(String.valueOf(key), beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> T mapToBean1(Map map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
        ArrayList list = Lists.newArrayList();
        if (objList != null && objList.size() > 0) {
            Map<String, Object> map = null;
            T bean = null;
            int size = objList.size();
            for (int i = 0; i < size; ++i) {
                bean = objList.get(i);
                map = BeanUtils.beanToMap(bean);
                list.add(map);
            }
        }
        return list;
    }

    public static <T> List<T> mapsToObjects(List<Map<String, Object>> maps, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        ArrayList list = Lists.newArrayList();
        if (maps != null && maps.size() > 0) {
            Map<String, Object> map = null;
            Object bean = null;
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                bean = clazz.newInstance();
                BeanUtils.mapToBean(map, bean);
                list.add(bean);
            }
        }
        return list;
    }

    public static <T, F> void beanCopy(T source, F object) {
        BeanCopier b = BeanCopier.create(source.getClass(), object.getClass(), (boolean)false);
        b.copy(source, object, null);
    }

    public static <T> Object getFieldValue(T var1, String fieldName) {
        Object fieldValue = null;
        if (StringUtil.isEmpty((String)fieldName)) {
            throw new NullArgumentException("fieldName is null");
        }
        String firstChar = ((String)fieldName).substring(0, 1).toUpperCase();
        fieldName = firstChar + ((String)fieldName).substring(1);
        try {
            Method getMethod = var1.getClass().getMethod("get" + (String)fieldName, Object.class);
            fieldValue = getMethod.invoke(var1, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new NullArgumentException((String)fieldName + "\u4e0d\u5b58\u5728");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return fieldValue;
    }

    public static void beanCopy1(Object source, Object target, String ... ignoreProperties) {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
    }

    public static void beanCopy(Object source, Object target, String ... fieldNames) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = org.springframework.beans.BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> inList = fieldNames != null ? Arrays.asList(fieldNames) : null;
        PropertyDescriptor[] var7 = targetPds;
        int var8 = targetPds.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = var7[var9];
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || !inList.contains(targetPd.getName()) || (sourcePd = org.springframework.beans.BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
                continue;
            }
            catch (Throwable var15) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", var15);
            }
        }
    }
}

