/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static Map<String, Object> values = new HashMap<String, Object>();

    public static int intValue(String key) {
        return Integer.valueOf(values.get(key).toString());
    }

    public static String value(String key) {
        return values.get(key).toString();
    }

    public static String value(String key, String def) {
        Object v = values.get(key);
        return v != null ? v.toString() : def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties p = new Properties();
        InputStream pInStream = null;
        try {
            pInStream = Config.class.getClassLoader().getResourceAsStream("application.properties");
            p.load(pInStream);
            Enumeration<?> enu = p.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                values.put(key, p.get(key));
            }
            log.info("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5b8c\u6bd5" + values.toString());
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                if (pInStream != null) {
                    pInStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

