/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.log;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.SqlLogEntity;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class LoggerUtil {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtil.class);

    public static AccessLogEntity getAccessLog(HttpServletRequest request) {
        AccessLogEntity log = new AccessLogEntity();
        try {
            Cookie cookie;
            String api = request.getRequestURI();
            String referer = request.getHeader("referer");
            String url = request.getRequestURL().toString();
            String userAgent = request.getHeader("User-Agent");
            String params = JsonUtils.toJson(request.getParameterMap(), false);
            String sign = request.getParameter("userTicket");
            String page = request.getHeader("Pagerouterurl");
            log.setIp(IpUtil.getCliectIp(request));
            log.setOperator("operator");
            log.setUserId("");
            log.setAction(api);
            String customerId = "";
            if (request != null && (cookie = CookieUtils.getCookie(request, "user")) != null) {
                customerId = URLDecoder.decode(cookie.getValue(), "utf-8");
            }
            log.setCustomerId(customerId);
            log.setMessage("\u63a5\u53e3\u76d1\u63a7");
            log.setReferer(referer);
            log.setBeginTime(System.currentTimeMillis());
            log.setUrl(page);
            log.setUserAgent(userAgent);
            log.setParams(params);
            log.setSign(sign);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return log;
    }

    public static AccessLogEntity getAccessLog(ServerHttpRequest request) {
        AccessLogEntity log = new AccessLogEntity();
        try {
            HttpCookie cookie;
            String api = request.getURI().getPath().toString();
            String referer = request.getHeaders().getFirst("referer");
            String url = request.getURI().toString();
            String userAgent = request.getHeaders().getFirst("User-Agent");
            String params = JsonUtils.toJson(request.getQueryParams(), false);
            String sign = (String)request.getQueryParams().getFirst((Object)"userTicket");
            String page = request.getHeaders().getFirst("Pagerouterurl");
            log.setIp(IpUtil.getCliectIp(request));
            log.setOperator("operator");
            log.setUserId("");
            log.setAction(api);
            String customerId = "";
            if (request != null && (cookie = CookieUtils.getCookie(request, "user")) != null) {
                customerId = URLDecoder.decode(cookie.getValue(), "utf-8");
            }
            log.setCustomerId(customerId);
            log.setMessage("\u63a5\u53e3\u76d1\u63a7");
            log.setReferer(referer);
            log.setBeginTime(System.currentTimeMillis());
            log.setUrl(page);
            log.setUserAgent(userAgent);
            log.setParams(params);
            log.setSign(sign);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return log;
    }

    public static SqlLogEntity WriteSqlLog(String isTrans, String rw, String customerId, String service, long beginTime, long endTime, long runTimes, String sql, String db, String sign) {
        SqlLogEntity log = new SqlLogEntity();
        log.setRunTimes(runTimes);
        log.setBeginTime(beginTime);
        log.setTrans(isTrans);
        log.setRw(rw);
        log.setCustomerId(customerId);
        log.setDb(db);
        log.setEndTime(endTime);
        log.setService(service);
        log.setSqls(sql);
        log.setSign(sign);
        return log;
    }
}

