/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.sign;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class EncodeUtils {
    private static final String DEFAULT_URL_ENCODING = "UTF-8";

    public static final String hexEncode(byte[] input) {
        return Hex.encodeHexString((byte[])input);
    }

    public static final byte[] hexDecode(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException("Hex Decoder exception", e);
        }
    }

    public static final String base64Encode(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static final String base64UrlSafeEncode(byte[] input) {
        return Base64.encodeBase64URLSafeString((byte[])input);
    }

    public static final byte[] base64Decode(String input) {
        return Base64.decodeBase64((String)input);
    }

    public static final String base64Decode1(String input) {
        return EncodeUtils.fromBytes(EncodeUtils.base64Decode(input));
    }

    private static String fromBytes(byte[] bytes) {
        return EncodeUtils.fromBytes(bytes, 0, bytes.length);
    }

    private static String fromBytes(byte[] bytes, int off, int len) {
        try {
            return new String(bytes, off, len, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static final String urlEncode(String input) {
        return EncodeUtils.urlEncode(input, DEFAULT_URL_ENCODING);
    }

    public static final String urlEncode(String input, String encoding) {
        try {
            return URLEncoder.encode(input, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding Exception", e);
        }
    }

    public static final String urlDecode(String input) {
        return EncodeUtils.urlDecode(input, DEFAULT_URL_ENCODING);
    }

    public static final String urlDecode(String input, String encoding) {
        try {
            return URLDecoder.decode(input, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding Exception", e);
        }
    }
}

