/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlSegment {
    private static final String Crlf = "@";
    private static final String FourSpace = "\u3000\u3000";
    private String start = "";
    private String body = "";
    private String end = "";
    private String bodySplitPattern;
    private String segmentRegExp;
    private List<String> bodyPieces;

    public SqlSegment(String segmentRegExp, String bodySplitPattern) {
        this.segmentRegExp = segmentRegExp;
        this.bodySplitPattern = bodySplitPattern;
        this.bodyPieces = new ArrayList<String>();
    }

    public void parse(String sql) {
        Pattern pattern = Pattern.compile(this.segmentRegExp, 2);
        for (int i = 0; i <= sql.length(); ++i) {
            String shortSql = sql.substring(0, i);
            Matcher matcher = pattern.matcher(shortSql);
            if (!matcher.find()) continue;
            this.start = matcher.group(1);
            this.body = matcher.group(2);
            this.end = matcher.group(3);
            this.parseBody();
            return;
        }
    }

    private void parseBody() {
        ArrayList<String> ls = new ArrayList<String>();
        Pattern p = Pattern.compile(this.bodySplitPattern, 2);
        this.body = this.body.trim();
        Matcher m = p.matcher(this.body);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            m.appendReplacement(sb, m.group(0) + Crlf);
            result = m.find();
        }
        m.appendTail(sb);
        String[] arr = sb.toString().split(" ");
        int arrLength = arr.length;
        for (int i = 0; i < arrLength; ++i) {
            String temp = FourSpace + arr[i];
            if (i != arrLength - 1) {
                // empty if block
            }
            ls.add(temp);
        }
        this.bodyPieces = ls;
    }

    public String getParsedSqlSegment() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.start + Crlf);
        for (String piece : this.bodyPieces) {
            sb.append(piece + Crlf);
        }
        return sb.toString();
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }
}

