/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.crowd;

import cc.lechun.active.entity.crowd.CrowdFundingForumEntity;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.weixin.MiniApiInterface;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/crowd"})
public class CrowdController {
    @Autowired
    private CrowdInterface crowdInterface;
    @Autowired
    MiniApiInterface miniApiInterface;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"/getCrowdInfo"})
    public BaseJsonVo getCrowdInfo() {
        return this.crowdInterface.getCrowdInfo();
    }

    @RequestMapping(value={"/getCrowdActiveList"})
    public BaseJsonVo getCrowdActiveList(int type) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setCustomerId("");
        }
        return this.crowdInterface.getCrowdActiveList(type, customerDetailVo);
    }

    @RequestMapping(value={"/getCrowdInviteList"})
    public BaseJsonVo getCrowdInviteList(Integer crowdId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setCustomerId("");
        }
        return this.crowdInterface.getCrowdInviteList(crowdId, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"/getMyCrowd"})
    public BaseJsonVo getMyCrowd(Integer currentPage, Integer pageSize) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setCustomerId("");
        }
        return BaseJsonVo.success((Object)this.crowdInterface.getMyCrowd(customerDetailVo.getCustomerId(), currentPage, pageSize));
    }

    @RequestMapping(value={"/getCrowdShareSubQrcode"})
    public BaseJsonVo getCrowdShareSubQrcode(String activeNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setCustomerId("");
            customerDetailVo.setSubscribe(0);
        }
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowdShareSubQrcode(customerDetailVo, activeNo));
    }

    @RequestMapping(value={"/getCrowdSuccessDetail"})
    public BaseJsonVo getCrowdSuccessDetail(String activeNo, String orderMainNo, String crowdId) {
        return this.crowdInterface.getCrowdSuccessDetail(activeNo, orderMainNo, crowdId);
    }

    @RequestMapping(value={"/getCrowdList"})
    public BaseJsonVo getCrowdList(String activeNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setCustomerId("");
        }
        return this.crowdInterface.getCrowdList(customerDetailVo.getCustomerId(), activeNo);
    }

    @RequestMapping(value={"saveCrowdForum"})
    public BaseJsonVo saveCrowdForum(CrowdFundingForumEntity crowdFundingForumEntity) throws AuthorizeException {
        if (StringUtils.isEmpty((CharSequence)crowdFundingForumEntity.getActiveNo())) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f17\u7b79\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)crowdFundingForumEntity.getForumMsgContnet())) {
            return BaseJsonVo.error((String)"\u8bf7\u8f93\u5165\u5185\u5bb9");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        crowdFundingForumEntity.setCustomerId(customerDetailVo.getCustomerId());
        BaseJsonVo baseJsonVo = this.miniApiInterface.msgCheck(customerDetailVo.getPlatformId(), crowdFundingForumEntity.getForumMsgContnet());
        if (!baseJsonVo.isSuccess()) {
            return BaseJsonVo.error((String)"\u60a8\u7684\u8bc4\u8bba\u6709\u654f\u611f\u5185\u5bb9\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\uff01");
        }
        return this.crowdInterface.saveCrowdForum(customerDetailVo, crowdFundingForumEntity);
    }

    @RequestMapping(value={"saveCrowdProductForum"})
    public BaseJsonVo saveCrowdProductForum(CrowdFundingForumEntity crowdFundingForumEntity) throws AuthorizeException {
        if (StringUtils.isEmpty((CharSequence)crowdFundingForumEntity.getActiveNo())) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f17\u7b79\u4fe1\u606f");
        }
        if (crowdFundingForumEntity.getCrowdId() == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f17\u7b79\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)crowdFundingForumEntity.getForumMsgContnet())) {
            return BaseJsonVo.error((String)"\u8bf7\u8f93\u5165\u5185\u5bb9");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.miniApiInterface.msgCheck(customerDetailVo.getPlatformId(), crowdFundingForumEntity.getForumMsgContnet());
        if (!baseJsonVo.isSuccess()) {
            return BaseJsonVo.error((String)"\u60a8\u7684\u8bc4\u8bba\u6709\u654f\u611f\u5185\u5bb9\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\uff01");
        }
        return this.crowdInterface.saveCrowdProductForum(customerDetailVo, crowdFundingForumEntity);
    }

    @RequestMapping(value={"getCrowdListDetail"})
    public BaseJsonVo getCrowdListDetail(CrowdFundingForumEntity crowdFundingForumEntity) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setCustomerId("");
        }
        if (crowdFundingForumEntity.getCrowdId() == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f17\u7b79\u4fe1\u606f");
        }
        return this.crowdInterface.getCrowdListDetail(customerDetailVo.getCustomerId(), crowdFundingForumEntity.getCrowdId().intValue());
    }

    @RequestMapping(value={"getCrowdForumList"})
    public BaseJsonVo getCrowdForumList(Integer crowdId, String forumSource, Integer currentPage, Integer pageSize) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            customerDetailVo = new CustomerDetailVo();
            customerDetailVo.setCustomerId("");
        }
        return this.crowdInterface.getCrowdForumList(customerDetailVo.getCustomerId(), crowdId.intValue(), forumSource.toString(), currentPage.intValue(), pageSize.intValue());
    }

    @RequestMapping(value={"saveLike"})
    public BaseJsonVo saveLike(String forumId) throws AuthorizeException {
        if (StringUtils.isEmpty((CharSequence)forumId)) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u8bc4\u8bbaID");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.crowdInterface.saveLike(customerDetailVo.getCustomerId(), forumId);
    }
}

