/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.index;

import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.scrollpic.ScrollPicTypeEnum;
import cc.lechun.common.enums.sync.DataSyncStatusEnum;
import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.object.SpELUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.scrollpic.MallScrollPicDetailEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.scrollpic.MallScrollPicDetailInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderSendMsgInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/index"})
public class IndexController {
    private static final Logger log = LoggerFactory.getLogger(IndexController.class);
    @Value(value="${lechun.oldapi.domain:}")
    private String oldApiHost;
    @Autowired
    private MallIndexItemInterface indexItemInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private DeliverInterface deliverService;
    @Autowired
    private MallScrollPicDetailInterface mallScrollPicDetailInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private CustomerAddressInterface addressService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    MallOrderSendMsgInterface mallOrderSendMsgService;
    @Autowired
    MallDataSyncInterface syncInterface;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;

    @RequestMapping(value={"getIndexNavProductList"})
    @ResponseBody
    public BaseJsonVo getIndexNavProductList(int itemType) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        try {
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
            String customerId = "";
            if (customerDetailVo != null) {
                customerId = customerDetailVo.getCustomerId();
            }
            baseJsonVo = this.indexItemInterface.getIndexNavProductList(Integer.valueOf(platformId), customerId, itemType);
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"getProductListByTicketBatchId"})
    @ResponseBody
    public BaseJsonVo getProductListByTicketBatchId(String ticketBatchId, Integer ticketCustomerId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        CashticketCustomerEntity cashticketCustomerEntity = this.cashticketCustomerInterface.getCashticketCustomer(ticketCustomerId.intValue());
        if (cashticketCustomerEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f18\u60e0\u5238");
        }
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(ticketBatchId);
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f18\u60e0\u5238\u6279\u6b21");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", this.indexItemInterface.getIndexNavProductListWithoutSpeedupNoLogin(customerDetailVo.getPlatformId(), customerDetailVo.getCustomerId(), Integer.valueOf(0), ticketBatchId));
        map.put("minUseamount", cashticketBatchEntity.getMinUseamount());
        map.put("ticketAmount", cashticketCustomerEntity.getTicketAmount());
        map.put("ticketAmount", cashticketCustomerEntity.getTicketAmount());
        map.put("discountMode", MathUtils.divBigDecimal((Number)cashticketBatchEntity.getDiscountAmount(), (Number)10, (Integer)2));
        String str = "";
        if (cashticketBatchEntity.getMinUseamount().doubleValue() == 0.0) {
            str = "\u65e0\u95e8\u69db";
        } else {
            str = new BigDecimal(cashticketBatchEntity.getMinUseamount().intValue()).compareTo(cashticketBatchEntity.getMinUseamount()) == 0 ? str + "\u6ee1" + cashticketBatchEntity.getMinUseamount().intValue() + "\u5143" : str + "\u6ee1" + cashticketBatchEntity.getMinUseamount().doubleValue() + "\u5143";
            if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
                str = new BigDecimal(cashticketCustomerEntity.getTicketAmount().intValue()).compareTo(cashticketCustomerEntity.getTicketAmount()) == 0 ? str + "\u51cf" + cashticketCustomerEntity.getTicketAmount().intValue() : str + "\u51cf" + cashticketCustomerEntity.getTicketAmount().doubleValue();
            } else if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
                BigDecimal zhe = MathUtils.divBigDecimal((Number)cashticketBatchEntity.getDiscountAmount(), (Number)10, (Integer)2);
                str = new BigDecimal(zhe.intValue()).compareTo(zhe) == 0 ? str + "\u6253" + zhe.intValue() + "\u6298" : str + "\u6253" + (String.valueOf(zhe.doubleValue()).endsWith("0") ? String.valueOf(zhe.doubleValue()).substring(0, String.valueOf(zhe.doubleValue()).length() - 2) : String.valueOf(zhe.doubleValue()));
            }
        }
        map.put("useDesc", str);
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"getFirstPageCount"})
    @ResponseBody
    public BaseJsonVo getFirstPageCount() throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        baseJsonVo.setStatus(200);
        try {
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (customerDetailVo == null) {
                map.put("cashCount", 0);
                map.put("balance", 0);
                map.put("isSubscribe", 0);
                int orderCount = 0;
                map.put("isNew", orderCount == 0 ? 1 : 0);
                map.put("isNew2", orderCount == 2 ? 1 : 0);
                map.put("isNew5", orderCount == 5 ? 1 : 0);
                HashMap<String, Object> mapIsOpen = new HashMap<String, Object>();
                mapIsOpen.put("isin", 0);
                mapIsOpen.put("isopen", "0");
                mapIsOpen.put("message", "");
                map.put("isOpen", mapIsOpen);
                HashMap<String, Object> mapVip = new HashMap<String, Object>();
                mapVip.put("isVip", 0);
                mapVip.put("vipOrderCount", 0);
                mapVip.put("maxLevelOrderShort", 0);
                mapVip.put("vipDay", this.vipInterface.getMallVipDay());
                HashMap vipTask = new HashMap();
                mapVip.put("vipTask", vipTask);
                map.put("vipInfo", mapVip);
                baseJsonVo.setValue(map);
                return baseJsonVo;
            }
            map.put("cashCount", this.cashticketCustomerInterface.getCashticketCount(customerDetailVo.getCustomerId(), Integer.valueOf(1)));
            map.put("balance", this.accountBalanceInterface.getGiftBalanceById(customerDetailVo.getCustomerId()));
            map.put("isSubscribe", customerDetailVo.getSubscribe());
            int orderCount = this.orderMainInterface.getOrderCount(customerDetailVo.getCustomerId(), Integer.valueOf(3), Integer.valueOf(16));
            map.put("isNew", orderCount == 0 ? 1 : 0);
            map.put("isNew2", orderCount == 2 ? 1 : 0);
            map.put("isNew5", orderCount == 5 ? 1 : 0);
            HashMap<String, Object> mapIsOpen = new HashMap<String, Object>();
            mapIsOpen.put("isin", 0);
            mapIsOpen.put("isopen", "0");
            mapIsOpen.put("message", "");
            map.put("isOpen", mapIsOpen);
            MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerDetailVo.getCustomerId());
            Map mapVip = ObjectConvert.objectConvertToObjectMap((Object)vipEntity);
            mapVip.put("isVip", String.valueOf(vipEntity == null ? 0 : (vipEntity.getLevel() > 0 ? 1 : 0)));
            mapVip.put("vipOrderCount", String.valueOf(this.orderInterface.getUserOrderCount(customerDetailVo.getCustomerId())));
            mapVip.put("maxLevelOrderShort", String.valueOf(this.vipInterface.getMaxLevelOrderShort(customerDetailVo.getCustomerId())));
            mapVip.put("vipDay", this.vipInterface.getMallVipDay());
            mapVip.put("isVipDay", this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
            Map vipTask = this.vipInterface.pushCustomerTask(customerDetailVo.getCustomerId());
            if (vipTask != null && vipTask.keySet().size() == 0) {
                vipTask = null;
            }
            mapVip.put("vipTask", vipTask);
            map.put("vipInfo", mapVip);
            baseJsonVo.setValue(map);
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"getItemDetail"})
    @ResponseBody
    public BaseJsonVo getItemDetail(String itemId, int itemType, Integer isQuick) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        if (isQuick == null) {
            isQuick = 0;
        }
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        try {
            MallVipEntity vipEntity;
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
            String customerId = "";
            if (customerDetailVo != null) {
                customerId = customerDetailVo.getCustomerId();
            }
            baseJsonVo = this.indexItemInterface.getItemDetail(customerId, itemId, itemType, Integer.valueOf((vipEntity = this.vipInterface.getUserVipInfo(customerId)) == null || vipEntity.getLevel() == null ? 0 : vipEntity.getLevel()));
            if (itemType == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                MallIndexProductVo vo = (MallIndexProductVo)baseJsonVo.getValue();
                vo.setSpeedUp(String.valueOf(isQuick));
                int productStock = this.deliverService.getProductStock(customerId, vo.getProductId());
                vo.setSpeedupStockNum(productStock);
            }
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"getScrollPicDetailList"})
    @ResponseBody
    public BaseJsonVo getScrollPicDetailList() throws AuthorizeException {
        int platFormId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        CustomerEntity customerEntity = null;
        MallVipEntity mallVipEntity = null;
        if (customerDetailVo != null) {
            customerEntity = this.customerInterface.getCustomer(customerDetailVo.getCustomerId());
            mallVipEntity = this.vipInterface.getUserVipInfo(customerDetailVo.getCustomerId());
        }
        HashMap<String, String> replace_map = new HashMap<String, String>();
        replace_map.put("indexPageVipDesc", "<b>\u798f\u5229</b>\u53d1\u653e\u4e2d");
        if (mallVipEntity != null && mallVipEntity.getLevel() != null && mallVipEntity.getLevel() != 0) {
            replace_map.put("indexPageVipDesc", "\u4f1a\u5458\u7b49\u7ea7<b>V" + mallVipEntity.getLevel() + "</b>");
        }
        List rs_banner = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageBanner.getValue());
        this.validCustomer(rs_banner, customerEntity, mallVipEntity, replace_map);
        List rs_ggw = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageGGW.getValue());
        this.validCustomer(rs_ggw, customerEntity, mallVipEntity, replace_map);
        List rs_ksrk = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageKSRK.getValue());
        this.validCustomer(rs_ksrk, customerEntity, mallVipEntity, replace_map);
        List rs_kp = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageKP.getValue());
        this.validCustomer(rs_kp, customerEntity, mallVipEntity, replace_map);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("banner", rs_banner);
        map.put("ggw", rs_ggw);
        map.put("ksrk", rs_ksrk);
        map.put("kpt", rs_kp);
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"getImageTextLinkList"})
    @ResponseBody
    public BaseJsonVo getImageTextLinkList(int picType) throws AuthorizeException {
        int platFormId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        CustomerEntity customerEntity = null;
        MallVipEntity mallVipEntity = null;
        if (customerDetailVo != null) {
            customerEntity = this.customerInterface.getCustomer(customerDetailVo.getCustomerId());
            mallVipEntity = this.vipInterface.getUserVipInfo(customerDetailVo.getCustomerId());
        }
        List ls = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, picType);
        this.validCustomer(ls, customerEntity, mallVipEntity, null);
        return BaseJsonVo.success((Object)ls);
    }

    private void validCustomer(List<MallScrollPicDetailEntity> rs, CustomerEntity customerEntity, MallVipEntity mallVipEntity, HashMap replace_map) {
        if (rs != null && rs.size() > 0) {
            rs = rs.stream().filter(mallScrollPicDetailEntity -> {
                if (replace_map != null && replace_map.size() > 0) {
                    mallScrollPicDetailEntity.setSummary(this.replaceVariable(mallScrollPicDetailEntity.getSummary(), replace_map));
                }
                if (mallScrollPicDetailEntity.getScrollType() != 0) {
                    if (mallVipEntity != null && mallVipEntity.getLevel() != null) {
                        if (mallScrollPicDetailEntity.getScrollType() == 1 ? mallVipEntity.getLevel() == 0 : mallScrollPicDetailEntity.getScrollType() == 2 && mallVipEntity.getLevel() != 0) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (mallScrollPicDetailEntity.getUserType() != 0) {
                    if (customerEntity != null) {
                        if (mallScrollPicDetailEntity.getUserType() == 1 ? customerEntity.getIsNew() != 1 : mallScrollPicDetailEntity.getUserType() == 2 && customerEntity.getIsNew() != 0) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
        }
    }

    private String replaceVariable(String str, HashMap map) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        return SpELUtils.readExpr((String)str, (Map)map);
    }

    @RequestMapping(value={"health"})
    @ResponseBody
    public BaseJsonVo health() throws AuthorizeException {
        return BaseJsonVo.success((Object)"success");
    }

    @RequestMapping(value={"dic"})
    @ResponseBody
    public BaseJsonVo dic() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.dictionaryInterface.getValidDictionaryList(Integer.valueOf(1), Integer.valueOf(8)));
    }

    @RequestMapping(value={"consumer"})
    @ResponseBody
    public BaseJsonVo consumer(int billType, int synchroStatus) throws AuthorizeException {
        return this.syncInterface.consumerData(DataSyncTypeEnum.valueOf((String)DataSyncTypeEnum.getName((int)billType)), DataSyncStatusEnum.valueOf((String)DataSyncStatusEnum.getName((int)synchroStatus)));
    }
}

