/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.trade;

import cc.lechun.common.enums.sales.FreeRuleTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInFreeVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/order"})
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    MallFreeInterface freeService;

    @RequestMapping(value={"setOrderCache"})
    @ResponseBody
    public BaseJsonVo setOrderCache(int platFormId, int orderSource, String bindCode, int deliverType, int deliverCount, int deliverPeriod, String items, String defineField) throws AuthorizeException, UnsupportedEncodingException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(deliverCount);
        inVo.setDeliverPeriod(deliverPeriod);
        inVo.setDeliverType(deliverType);
        inVo.setOrderSource(orderSource);
        inVo.setBindCode(bindCode);
        inVo.setDefineField(defineField);
        items = URLDecoder.decode(items, "utf-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List itemVoList = JsonUtils.getListByArray(MallOrderCacheInItemVo.class, (String)items);
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        BaseJsonVo baseJsonVo = this.tradeInterface.setOrderCache(platFormId, customerDetailVo.getCustomerId(), inVo);
        return baseJsonVo;
    }

    @RequestMapping(value={"toPayPage"})
    @ResponseBody
    public BaseJsonVo toPayPage(int platFormId, String cacheId, String bindCode, int orderSource, String isQuick, String speedUp) throws AuthorizeException {
        MallMainOrderVo mallMainOrderVo;
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        MallOrderCacheVo cacheVo = new MallOrderCacheVo();
        cacheVo.setBindCode(bindCode);
        cacheVo.setCacheId(cacheId);
        cacheVo.setOrderSource(orderSource);
        if ("1".equals(isQuick)) {
            cacheVo.setIsQuick(1);
        }
        if (orderSource == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            cacheVo.setSpeedUp(0);
        } else if ("1".equals(speedUp)) {
            cacheVo.setSpeedUp(1);
        } else if ("0".equals(speedUp)) {
            cacheVo.setSpeedUp(0);
        }
        BaseJsonVo baseJsonVo = this.tradeInterface.toPayPage(platFormId, customerDetailVo.getCustomerId(), cacheVo);
        if (baseJsonVo.isSuccess() && (mallMainOrderVo = (MallMainOrderVo)baseJsonVo.getValue()) != null) {
            BaseJsonVo exchangeResult;
            BigDecimal orderAmount = mallMainOrderVo.getOrderAmount();
            mallMainOrderVo.setOrderAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getOrderAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
            mallMainOrderVo.setTotalAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
            mallMainOrderVo.getMallOrderVos().forEach(mallOrderVo -> {
                if (mallOrderVo.getFrees() != null && mallOrderVo.getFrees().size() > 0 && ((MallFreeVO)mallOrderVo.getFrees().get(0)).getRuleType() != null && ((MallFreeVO)mallOrderVo.getFrees().get(0)).getRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
                    mallOrderVo.setFrees(new ArrayList());
                }
            });
            if (orderSource == OrderSourceEnum.CART.getValue() && (exchangeResult = this.freeService.buildExchangeProductList(mallMainOrderVo.getMallOrderVos(), customerDetailVo.getPlatformGroupId(), orderAmount)).isSuccess()) {
                MallOrderVo mallOrderVo2 = (MallOrderVo)mallMainOrderVo.getMallOrderVos().get(0);
                if (mallOrderVo2.getEnableExchanges() == null) {
                    mallOrderVo2.setEnableExchanges(new ArrayList());
                }
                mallOrderVo2.setEnableExchanges((List)exchangeResult.getValue());
            }
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"createOrderAndPay"})
    @ResponseBody
    public BaseJsonVo createOrderAndPay(int platFormId, String orderCacheJson, String isQuick, String exchangeItems) throws AuthorizeException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        String message = "";
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (this.memcachedService.isExceedCount("OrderController", "createOrderAndPay_" + customerDetailVo.getCustomerId(), 1, 2)) {
            return BaseJsonVo.error((String)"\u963f\u5076\uff01\u6b47\u6b47\u5427\uff0c\u4e0d\u8981\u7d2f\u5012\u5566~~~");
        }
        orderCacheJson = URLDecoder.decode(orderCacheJson, "utf-8");
        log.info("+++++createOrderAndPay.orderCacheJson+++orderCacheJson={}", (Object)orderCacheJson);
        MallOrderCacheVo orderCacheVo = (MallOrderCacheVo)JsonUtils.fromJson((String)orderCacheJson, MallOrderCacheVo.class);
        if (StringUtils.isNotEmpty((String)exchangeItems)) {
            if (!(exchangeItems = URLDecoder.decode(exchangeItems, "utf-8")).startsWith("[")) {
                exchangeItems = "[" + exchangeItems + "]";
            }
            log.info("exchangetItems={}", (Object)exchangeItems);
            List exchangeList = JsonUtils.getListByArray(MallOrderCacheInFreeVo.class, (String)exchangeItems);
            if (exchangeList != null && exchangeList.size() > 0) {
                orderCacheVo.setExchangeVoList(exchangeList);
            }
        } else {
            log.info("\u6ca1\u6709\u9009\u62e9\u8d60\u54c1 exchangetItems={}", (Object)exchangeItems);
        }
        if (orderCacheVo == null) {
            return BaseJsonVo.error((String)"\u8bf7\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606f");
        }
        String date = orderCacheVo.getDeliverDate() == null ? DateUtils.date() : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate(), (String)"yyyy-MM-dd");
        orderCacheVo.setDeliverDate(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        date = orderCacheVo.getDeliverDate2() == null ? DateUtils.date() : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate2(), (String)"yyyy-MM-dd");
        orderCacheVo.setDeliverDate2(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        if ("1".equals(isQuick)) {
            orderCacheVo.setIsQuick(1);
        }
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        Cookie cookie = CookieUtils.getCookie((HttpServletRequest)request, (String)"lechun_bindcode");
        if (cookie != null && cookie.getValue() != null) {
            orderCacheVo.setCookieBindCode(cookie.getValue());
        }
        BaseJsonVo baseJsonVo = this.tradeInterface.createOrder(platFormId, customerDetailVo.getCustomerId(), orderCacheVo);
        log.info("createResult : " + JsonUtils.toJson((Object)baseJsonVo, (boolean)true));
        if (baseJsonVo.isSuccess()) {
            Object o = baseJsonVo.getValue();
            PayOutputEntity payOutputEntity = this.payOrderInterface.topay(customerDetailVo.getCustomerId(), o.toString(), ip);
            log.info("payResult : " + JsonUtils.toJson((Object)payOutputEntity, (boolean)true));
            return BaseJsonVo.success((Object)payOutputEntity);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"cancelCustomerOrder"})
    @ResponseBody
    public BaseJsonVo cancelCustomerOrder(String orderMainNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.tradeInterface.cancelCustomerOrder(customerDetailVo.getCustomerId(), orderMainNo, 1);
        return baseJsonVo;
    }

    @RequestMapping(value={"deleteCustomerOrder"})
    @ResponseBody
    public BaseJsonVo deleteCustomerOrder(String orderMainNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.tradeInterface.deleteCustomerOrder(customerDetailVo.getCustomerId(), orderMainNo);
        return baseJsonVo;
    }

    @RequestMapping(value={"getCustomerOrderList"})
    @ResponseBody
    public BaseJsonVo getCustomerOrderList(int statusClass, int pageSize, int pageCount) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        ArrayList orderList = this.tradeInterface.getOrderList(customerDetailVo.getCustomerId(), statusClass, pageSize, pageCount);
        if (orderList == null) {
            orderList = new ArrayList();
        }
        return BaseJsonVo.success((Object)orderList);
    }

    @RequestMapping(value={"getCustomerOrderDetail"})
    @ResponseBody
    public BaseJsonVo getCustomerOrderDetail(String orderMainNo, String orderNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        OrderListVo orderListVo = this.tradeInterface.getOrderDetail(customerDetailVo.getCustomerId(), orderMainNo, orderNo);
        if (orderListVo == null) {
            return BaseJsonVo.error((String)"\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25\uff0c\u8bf7\u70b9\u51fb\u91cd\u8bd5");
        }
        return BaseJsonVo.success((Object)orderListVo);
    }

    @RequestMapping(value={"againTopay"})
    @ResponseBody
    public BaseJsonVo againTopay(String orderMainNo, int payTypeSubId) throws AuthorizeException {
        Optional<MallOrderPayEntity> orderPayEntity;
        List orderPayEntities;
        MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getDefaultPayType();
        if (mallPayTypeEntity != null) {
            payTypeSubId = mallPayTypeEntity.getPaytypeId();
        }
        if ((orderPayEntities = this.orderPayInterface.getList(orderMainNo)) != null && orderPayEntities.size() > 0 && (orderPayEntity = orderPayEntities.stream().filter(c -> c.getCashType() == 1).findFirst()).isPresent()) {
            payTypeSubId = orderPayEntity.get().getPaySubtypeId();
        }
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        PayOutputEntity payOutputEntity = this.payOrderInterface.againTopay(customerDetailVo.getCustomerId(), orderMainNo, payTypeSubId, ip);
        return BaseJsonVo.success((Object)payOutputEntity);
    }

    @RequestMapping(value={"confirmGoods"})
    @ResponseBody
    public BaseJsonVo confirmGoods(String orderMainNo, String orderNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.tradeInterface.confirmGoods(customerDetailVo.getCustomerId(), orderMainNo, orderNo == null ? "" : orderNo);
        return baseJsonVo;
    }

    @RequestMapping(value={"editOrderAddress"})
    @ResponseBody
    public BaseJsonVo editOrderAddress(String orderNo, String addressId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.orderInterface.editOrderAddress(customerDetailVo.getCustomerId(), orderNo, addressId);
        return baseJsonVo;
    }

    @RequestMapping(value={"editOrderDeliverDate"})
    @ResponseBody
    public BaseJsonVo editOrderDeliverDate(String orderNo, String deliverdate) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (StringUtils.isEmpty((String)orderNo) || StringUtils.isEmpty((String)deliverdate)) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        Date deliverDate = DateUtils.StrToDate((String)deliverdate, (String)"yyyy-MM-dd");
        if (deliverDate == null) {
            return BaseJsonVo.error((String)"\u914d\u9001\u65e5\u671f\u9519\u8bef");
        }
        BaseJsonVo baseJsonVo = this.orderInterface.editOrderDeliverDate(customerDetailVo.getCustomerId(), orderNo, deliverDate);
        return baseJsonVo;
    }

    @RequestMapping(value={"getorderdefaultdeliver"})
    @ResponseBody
    public BaseJsonVo getOrderDefaultDeliver(String orderno) throws AuthorizeException {
        return this.orderInterface.getOrderDefaultDeliverDate(orderno);
    }

    @RequestMapping(value={"getOrderEditProducts"})
    @ResponseBody
    public BaseJsonVo getOrderEditProducts(String orderno) throws AuthorizeException {
        return this.orderInterface.getOrderEditProducts(orderno);
    }

    @RequestMapping(value={"editOrderProducts"})
    @ResponseBody
    public BaseJsonVo editOrderProducts(String orderno, String products) throws AuthorizeException {
        ArrayList productList = new ArrayList();
        for (String pro : products.split(";")) {
            String[] proArray = pro.split(":");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("proId", proArray[0]);
            map.put("count", proArray[1]);
            productList.add(map);
        }
        return this.orderInterface.editOrderProducts(orderno, productList);
    }

    @RequestMapping(value={"testdeliverno"})
    @ResponseBody
    public BaseJsonVo testdeliverno(String userId, String orderNo) {
        MallOrderEntity order = this.orderInterface.getmallOrder(orderNo);
        OrderListVo orderListVo = this.tradeInterface.getOrderDetail(userId, order.getOrderMainNo(), orderNo);
        return BaseJsonVo.success((Object)orderListVo);
    }

    @RequestMapping(value={"testCreateOrder"})
    @ResponseBody
    public void Test() throws AuthorizeException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo baseJsonVo;
        int platFormId = 1;
        String orderCacheJson = "%7B%22cacheType%22%3A2%2C%22orderSource%22%3A0%2C%22cacheId%22%3A%22%22%2C%22bindCode%22%3A%22%22%2C%22ticketCustomerId%22%3A%22%22%2C%22addressId%22%3A%223342231890033085847%22%2C%22deliverDate%22%3A%222020-07-10%22%2C%22deliverDate2%22%3A%22%22%2C%22useAccountBalance%22%3A0%2C%22payPassword%22%3A%22%22%2C%22isOpenOrderPlan%22%3A-1%2C%22payType%22%3A12%2C%22miniformId%22%3A%22%22%2C%22giftType%22%3A0%2C%22isQuick%22%3A0%2C%22speedUp%22%3A%22%22%7D";
        String customerId = "10003341782013717652996";
        orderCacheJson = URLDecoder.decode(orderCacheJson, "utf-8");
        MallOrderCacheVo orderCacheVo = (MallOrderCacheVo)JsonUtils.fromJson((String)orderCacheJson, MallOrderCacheVo.class);
        String date = DateUtils.formatDate((Date)orderCacheVo.getDeliverDate(), (String)"yyyy-MM-dd");
        orderCacheVo.setDeliverDate(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        date = DateUtils.formatDate((Date)orderCacheVo.getDeliverDate2(), (String)"yyyy-MM-dd");
        orderCacheVo.setDeliverDate2(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        if (orderCacheVo == null) {
            BaseJsonVo.error((String)"\u8bf7\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606f");
        }
        orderCacheVo.setIsQuick(0);
        String exchangeItems = URLDecoder.decode("%5B%7B%22itemType%22%3A4%2C%22itemId%22%3A%223126356513562583378%22%2C%22quantity%22%3A2%2C%22freeId%22%3A%221270180353414139904%22%7D%5D", "utf-8");
        if (!exchangeItems.startsWith("[")) {
            exchangeItems = "[" + exchangeItems + "]";
        }
        log.info("exchangetItems={}", (Object)exchangeItems);
        List exchangeList = JsonUtils.getListByArray(MallOrderCacheInFreeVo.class, (String)exchangeItems);
        if (exchangeList != null && exchangeList.size() > 0) {
            orderCacheVo.setExchangeVoList(exchangeList);
        }
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        Cookie cookie = CookieUtils.getCookie((HttpServletRequest)request, (String)"lechun_bindcode");
        if (cookie != null && cookie.getValue() != null) {
            orderCacheVo.setCookieBindCode(cookie.getValue());
        }
        if ((baseJsonVo = this.tradeInterface.createOrder(platFormId, customerId, orderCacheVo)).isSuccess()) {
            Object o = baseJsonVo.getValue();
            PayOutputEntity payOutputEntity = this.payOrderInterface.topay(customerId, o.toString(), ip);
            log.info(JsonUtils.toJson((Object)payOutputEntity, (boolean)true));
            BaseJsonVo.success((Object)payOutputEntity);
        } else {
            log.info("sdafasdf");
        }
    }

    @RequestMapping(value={"testtoPayPage"})
    @ResponseBody
    public BaseJsonVo testtoPayPage(int platFormId, String cacheId, String bindCode, int orderSource, String isQuick, String speedUp) throws AuthorizeException {
        MallMainOrderVo mallMainOrderVo;
        MallOrderCacheVo cacheVo = new MallOrderCacheVo();
        cacheVo.setBindCode(bindCode);
        cacheVo.setCacheId(cacheId);
        cacheVo.setOrderSource(orderSource);
        if ("1".equals(isQuick)) {
            cacheVo.setIsQuick(1);
        }
        if (orderSource == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            cacheVo.setSpeedUp(0);
        } else if ("1".equals(speedUp)) {
            cacheVo.setSpeedUp(1);
        } else if ("0".equals(speedUp)) {
            cacheVo.setSpeedUp(0);
        }
        BaseJsonVo baseJsonVo = this.tradeInterface.toPayPage(platFormId, "10003341782013717652996", cacheVo);
        if (baseJsonVo.isSuccess() && (mallMainOrderVo = (MallMainOrderVo)baseJsonVo.getValue()) != null) {
            BigDecimal orderAmount = mallMainOrderVo.getOrderAmount();
            mallMainOrderVo.setOrderAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getOrderAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
            mallMainOrderVo.setTotalAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
            mallMainOrderVo.getMallOrderVos().forEach(mallOrderVo -> {
                if (mallOrderVo.getFrees() != null && mallOrderVo.getFrees().size() > 0 && ((MallFreeVO)mallOrderVo.getFrees().get(0)).getRuleType() != null && ((MallFreeVO)mallOrderVo.getFrees().get(0)).getRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
                    mallOrderVo.setFrees(new ArrayList());
                }
            });
            BaseJsonVo exchangeResult = this.freeService.buildExchangeProductList(mallMainOrderVo.getMallOrderVos(), Integer.valueOf(1000), orderAmount);
            if (exchangeResult.isSuccess()) {
                MallOrderVo mallOrderVo2 = (MallOrderVo)mallMainOrderVo.getMallOrderVos().get(0);
                if (mallOrderVo2.getEnableExchanges() == null) {
                    mallOrderVo2.setEnableExchanges(new ArrayList());
                }
                mallOrderVo2.setEnableExchanges((List)exchangeResult.getValue());
            }
        }
        return baseJsonVo;
    }
}

