/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.cache;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisService.class);
    @Resource(name="redisTemplate")
    private RedisTemplate redisTemplate;
    @Resource(name="redisTemplate")
    private ValueOperations vot;
    @Resource(name="redisTemplate")
    private ListOperations lot;
    @Resource(name="redisTemplate")
    private SetOperations sot;
    @Resource(name="redisTemplate")
    private ZSetOperations zsot;
    @Resource(name="redisTemplate")
    private HashOperations hot;

    public Boolean setnx(String key, String value) {
        try {
            return this.vot.setIfAbsent((Object)key, (Object)value);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean delete(String key) {
        try {
            this.redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public Boolean setExpire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public Object get(String key) {
        try {
            return this.vot.get((Object)key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public Object getAndSet(String key, Object value) {
        try {
            return this.vot.getAndSet((Object)key, value);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public boolean save(String key, Object value) {
        try {
            this.vot.set((Object)key, value);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean save(String key, Object value, long exp) {
        try {
            this.vot.set((Object)key, value, exp, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public long size(String key) {
        try {
            return this.vot.size((Object)key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0L;
        }
    }

    public double increment(String key, Double value) {
        try {
            return this.vot.increment((Object)key, value.doubleValue());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0.0;
        }
    }

    public long increment(String key, Long value) {
        try {
            return this.vot.increment((Object)key, value.longValue());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0L;
        }
    }

    public boolean hsave(String key, String hashKey, Object value) {
        try {
            this.hot.put((Object)key, (Object)hashKey, value);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean hHasKey(String key, String hashKey) {
        try {
            return this.hot.hasKey((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean sadd(String key, Object ... ls) {
        try {
            Long l = this.sot.add((Object)key, ls);
            if (l == 0L) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean sremove(String key, Object ... ls) {
        try {
            Long l = this.sot.remove((Object)key, ls);
            if (l == 0L) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public Long sSize(String key, Object ... ls) {
        try {
            Long l = this.sot.size((Object)key);
            return l;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean sIsMember(String key, Object obj) {
        try {
            return this.sot.isMember((Object)key, obj);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public Object spop(String key) {
        try {
            return this.sot.pop((Object)key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public List sRandomMembers(String key, long size) {
        try {
            return this.sot.randomMembers((Object)key, size);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }
}

