/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.common.enums.customer.CustomerAddressTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.tree.TreeBuilder;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerAddressMapper;
import cc.lechun.mall.dao.sales.MallGroupProductMapper;
import cc.lechun.mall.dao.shoppingcart.MallShoppingcartMapper;
import cc.lechun.mall.entity.common.MallTreeVo;
import cc.lechun.mall.entity.customer.AreaCityProvinceVo;
import cc.lechun.mall.entity.customer.AreaCityVo;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.customer.SysAreaVo;
import cc.lechun.mall.entity.customer.SysCityAreaVo;
import cc.lechun.mall.entity.customer.SysProvinceCityAreaVo;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartEntity;
import cc.lechun.mall.form.customer.AddressForm;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerAddressService
extends BaseService
implements CustomerAddressInterface {
    @Value(value="${lechun.oldapi.domain:}")
    private String oldApiHost;
    @Autowired
    private CustomerAddressMapper customerAddressMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    MallCityInterface cityService;
    @Autowired
    MallAreaInterface areaService;
    @Autowired
    MallShoppingcartMapper cartMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallGroupProductMapper groupProductMapper;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;
    @Autowired
    MallGroupInterface groupInterface;
    @Value(value="${erp.provinceAreaList.url}")
    private String provinceAreaListUrl;
    @Value(value="${erp.getArea.url}")
    private String getAreaUrl;

    @Override
    public List<CustomerAddressTypeEnum> getAddressType() {
        return CustomerAddressTypeEnum.getList();
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerAddress", expiration=7200)
    public CustomerAddressEntity getCustomerAddress(@ParameterValueKeyProvider String addrId) {
        return (CustomerAddressEntity)this.customerAddressMapper.selectByPrimaryKey((Serializable)((Object)addrId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getValidCustomerAddressList", expiration=7200)
    public List<CustomerAddressEntity> getValidCustomerAddressList(@ParameterValueKeyProvider String customerId) {
        return this.customerAddressMapper.getValidCustomerAddressList(customerId);
    }

    @Override
    @Transactional
    public BaseJsonVo saveCustomerAddress(AddressForm form) {
        BaseJsonVo vo = this.validateAddress(form);
        if (!vo.isSuccess()) {
            return vo;
        }
        CustomerAddressEntity customerAddressEntity = new CustomerAddressEntity();
        customerAddressEntity.setAddrId(RandomUtils.generateStrId());
        customerAddressEntity.setCustomerId(form.getCustomerId());
        customerAddressEntity.setAddress(form.getAddress());
        customerAddressEntity.setConsigneeName(form.getConsigneename());
        customerAddressEntity.setConsigneePhone(form.getConsingeephone());
        customerAddressEntity.setAddressType(form.getAddresstype());
        customerAddressEntity.setCreateTime(DateUtils.now());
        customerAddressEntity.setConsigneeTel("");
        customerAddressEntity.setLastTime(DateUtils.now());
        AreaCityProvinceVo areaCityProvince = this.customerAddressMapper.getAreaCityProvinceForAreaId(form.getAreaid());
        customerAddressEntity.setAreaId(form.getAreaid());
        customerAddressEntity.setAreaName(areaCityProvince.getAreaName());
        customerAddressEntity.setCityId(areaCityProvince.getCityId());
        customerAddressEntity.setCityName(areaCityProvince.getCityName());
        customerAddressEntity.setProvinceId(areaCityProvince.getProvinceId());
        customerAddressEntity.setProvinceName(areaCityProvince.getProvinceName());
        this.customerAddressMapper.insertSelective(customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)customerAddressEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo updateCustomerAddress(AddressForm form) {
        BaseJsonVo vo = this.validateAddress(form);
        if (!vo.isSuccess()) {
            return vo;
        }
        CustomerAddressEntity customerAddressEntity = this.getCustomerAddress(form.getAddrId());
        customerAddressEntity.setAreaId(form.getAreaid());
        AreaCityProvinceVo areaCityProvince = this.customerAddressMapper.getAreaCityProvinceForAreaId(form.getAreaid());
        customerAddressEntity.setAreaId(form.getAreaid());
        customerAddressEntity.setAreaName(areaCityProvince.getAreaName());
        customerAddressEntity.setCityId(areaCityProvince.getCityId());
        customerAddressEntity.setCityName(areaCityProvince.getCityName());
        customerAddressEntity.setProvinceId(areaCityProvince.getProvinceId());
        customerAddressEntity.setProvinceName(areaCityProvince.getProvinceName());
        customerAddressEntity.setAddress(form.getAddress());
        customerAddressEntity.setConsigneeName(form.getConsigneename());
        customerAddressEntity.setConsigneePhone(form.getConsingeephone());
        customerAddressEntity.setAddressType(form.getAddresstype());
        this.customerAddressMapper.updateByPrimaryKeySelective(customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)customerAddressEntity);
    }

    @Override
    public CustomerAddressEntity updateAddressLastTime(String addrId) {
        CustomerAddressEntity customerAddressEntity = this.getCustomerAddress(addrId);
        customerAddressEntity.setLastTime(DateUtils.now());
        this.customerAddressMapper.updateByPrimaryKeySelective(customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return customerAddressEntity;
    }

    @Override
    @Transactional
    public BaseJsonVo updateCustomerAddress(String addrId) {
        CustomerAddressEntity customerAddressEntity = this.getCustomerAddress(addrId);
        customerAddressEntity.setIsDelete((short)1);
        this.customerAddressMapper.updateByPrimaryKeySelective(customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)customerAddressEntity);
    }

    @Override
    public List<AreaCityVo> getEnableArea(int areaId, int transportType) {
        return this.customerAddressMapper.getEnableArea(areaId, transportType);
    }

    private BaseJsonVo validateAddress(AddressForm form) {
        if (StringUtils.isEmpty((String)form.getConsingeephone())) {
            return BaseJsonVo.paramError((String)"\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)form.getConsigneename())) {
            return BaseJsonVo.paramError((String)"\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)form.getAddress())) {
            return BaseJsonVo.paramError((String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (form.getAddresstype() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5730\u5740\u7c7b\u578b");
        }
        if (form.getAreaid() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u57ce\u5e02");
        }
        return BaseJsonVo.success(null);
    }

    private void removeCache(String customerId, String addrId) {
        this.memcachedService.delete("getCustomerAddress", addrId);
        this.memcachedService.delete("getValidCustomerAddressList", customerId);
    }

    @Override
    public List<CustomerAddressVo> getValidCustomerAddressList(String customerId, String addressId, int transportType) {
        List<CustomerAddressEntity> addressList = this.getValidCustomerAddressList(customerId);
        if (addressId != null && !addressId.isEmpty()) {
            addressList = addressList.stream().filter(c -> c.getAddrId().equals(addressId)).collect(Collectors.toList());
        }
        ArrayList<CustomerAddressVo> customerAddressVos = new ArrayList<CustomerAddressVo>();
        for (CustomerAddressEntity e : addressList) {
            CustomerAddressVo customerAddressVo = new CustomerAddressVo();
            try {
                ObjectConvert.fatherConvertToChild((Object)e, (Object)customerAddressVo);
                customerAddressVo.setSpeedUp("0");
            }
            catch (Exception e1) {
                this.logger.error("\u83b7\u53d6\u5730\u5740\u5217\u8868\u65f6\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e1);
            }
            List<MallAreaEntity> mallAreaEntityList = this.getAreaErp(null, String.valueOf(e.getAreaId()), null);
            if (mallAreaEntityList != null && mallAreaEntityList.size() > 0) {
                for (MallAreaEntity mallAreaEntity : mallAreaEntityList) {
                    int status = mallAreaEntity.getStatus();
                    int nomalStatus = mallAreaEntity.getOrdinaryStatus();
                    customerAddressVo.setEnable(true);
                    if (transportType == 1) {
                        if (status == 1) {
                            customerAddressVo.setEnable(true);
                        } else {
                            customerAddressVo.setEnable(false);
                        }
                    }
                    if (transportType != 2) continue;
                    if (nomalStatus == 1) {
                        customerAddressVo.setEnable(true);
                        continue;
                    }
                    customerAddressVo.setEnable(false);
                }
            } else {
                customerAddressVo.setEnable(false);
            }
            customerAddressVos.add(customerAddressVo);
        }
        return customerAddressVos;
    }

    private List<MallAreaEntity> getAreaErp(String cityId, String areaId, String areaName) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("cityId", cityId);
        mapParam.put("areaId", areaId);
        mapParam.put("areaName", areaName);
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.getAreaUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        this.logger.info("*************************getAreaErp********************\u8c03\u7528ERP3.0\u83b7\u53d6areaList\u4f20\u9012\u548c\u8fd4\u56de\u7684\u53c2\u6570*************mapParam={},result={}", (Object)JSON.toJSONString(mapParam), (Object)result);
        if (StringUtils.isNotEmpty((String)result)) {
            JSONObject jsonObject = JSON.parseObject((String)result);
            int status = (Integer)jsonObject.get((Object)"status");
            if (status == 200) {
                boolean success = (Boolean)jsonObject.get((Object)"success");
                if (success) {
                    ArrayList<MallAreaEntity> mallAreaEntityArrayList = new ArrayList<MallAreaEntity>();
                    JSONArray jsonArrayCity = (JSONArray)jsonObject.get((Object)"result");
                    for (JSONObject ob : jsonArrayCity) {
                        String code = (String)ob.get((Object)"code");
                        String name = (String)ob.get((Object)"name");
                        String parentcode = (String)ob.get((Object)"parentcode");
                        Integer nomalstatus = ob.getInteger("nomalstatus");
                        Integer coldstatus = ob.getInteger("coldstatus");
                        Integer freshstatus = ob.getInteger("freshstatus");
                        MallAreaEntity mallAreaEntity = new MallAreaEntity();
                        mallAreaEntity.setAreaId(Integer.valueOf(code));
                        mallAreaEntity.setAreaName(name);
                        mallAreaEntity.setCityId(Integer.valueOf(parentcode));
                        mallAreaEntity.setStatus((int)coldstatus);
                        mallAreaEntity.setOrdinaryStatus((int)nomalstatus);
                        mallAreaEntityArrayList.add(mallAreaEntity);
                    }
                    return mallAreaEntityArrayList;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public CustomerAddressVo getCustomerDefaultAddress(String customerId, String areaId, String address, String requestIp, int[] transportTypeArry) throws Exception {
        List<CustomerAddressEntity> addrs;
        if (transportTypeArry == null) {
            List<MallShoppingcartEntity> list;
            List<MallShoppingcartEntity> cartGroupEntityList;
            transportTypeArry = new int[]{-1, -1};
            List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PRODUCT.getValue(), false);
            if ((cartEntityList = cartEntityList.stream().filter(c -> "0".equals(c.getSpeedUp()) && c.getChecked() == 1).collect(Collectors.toList())) != null && cartEntityList.size() > 0) {
                for (MallShoppingcartEntity mallShoppingcartEntity : cartEntityList) {
                    MallProductEntity mallProductEntity = this.productService.getProduct(mallShoppingcartEntity.getProductId());
                    if (mallProductEntity.getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                        transportTypeArry[0] = TransportTypeEnum.COLD_CHAIN.getValue();
                    }
                    if (mallProductEntity.getTransportType().intValue() != TransportTypeEnum.NORMAL_CHAIN.getValue()) continue;
                    transportTypeArry[1] = TransportTypeEnum.NORMAL_CHAIN.getValue();
                }
            } else {
                transportTypeArry[0] = 1;
            }
            if ((cartGroupEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_GROUP.getValue(), false)) != null && cartGroupEntityList.size() > 0) {
                for (MallShoppingcartEntity entity : cartGroupEntityList) {
                    List<MallGroupProductEntity> entities = this.groupProductMapper.getGroupProduct(entity.getGroupId());
                    if (entities == null || entities.size() <= 0) continue;
                    for (MallGroupProductEntity mallGroupProductEntity : entities) {
                        MallProductEntity mallProductEntity = this.productService.getProduct(mallGroupProductEntity.getProId());
                        if (mallProductEntity.getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                            transportTypeArry[0] = TransportTypeEnum.COLD_CHAIN.getValue();
                        }
                        if (mallProductEntity.getTransportType().intValue() != TransportTypeEnum.NORMAL_CHAIN.getValue()) continue;
                        transportTypeArry[1] = TransportTypeEnum.NORMAL_CHAIN.getValue();
                    }
                }
            }
            if ((list = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PROMOTION.getValue(), false)) != null && list.size() > 0) {
                for (MallShoppingcartEntity entity : list) {
                    List<MallGroupProductEntity> groupProducts;
                    MallPromotionProductEntity promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(entity.getPromotionId());
                    if (promotionProductEntity == null) continue;
                    if (promotionProductEntity.getProductType().equals(String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()))) {
                        MallProductEntity productEntity = this.productService.getProduct(promotionProductEntity.getProductId());
                        if (productEntity.getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                            transportTypeArry[0] = TransportTypeEnum.COLD_CHAIN.getValue();
                        }
                        if (productEntity.getTransportType().intValue() == TransportTypeEnum.NORMAL_CHAIN.getValue()) {
                            transportTypeArry[1] = TransportTypeEnum.NORMAL_CHAIN.getValue();
                        }
                    }
                    if (!promotionProductEntity.getProductType().equals(String.valueOf(SalesTypeEnum.SALES_GROUP.getValue())) || (groupProducts = this.groupInterface.getGroupProducts(promotionProductEntity.getProductId())) == null || groupProducts.size() <= 0) continue;
                    for (MallGroupProductEntity g : groupProducts) {
                        MallProductEntity productEntity = this.productService.getProduct(g.getProId());
                        if (productEntity == null) continue;
                        if (productEntity.getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                            transportTypeArry[0] = TransportTypeEnum.COLD_CHAIN.getValue();
                        }
                        if (productEntity.getTransportType().intValue() != TransportTypeEnum.NORMAL_CHAIN.getValue()) continue;
                        transportTypeArry[1] = TransportTypeEnum.NORMAL_CHAIN.getValue();
                    }
                }
            }
        }
        if ((addrs = this.getValidCustomerAddressList(customerId)) == null || addrs.size() == 0) {
            CustomerAddressEntity entity = new CustomerAddressEntity();
            entity.setAreaId(110100);
            entity.setCityId(110000);
            entity.setAddress("\u5317\u4eac");
            return this.buildAddressVO(entity, transportTypeArry);
        }
        return this.buildAddressVO(addrs.get(0), transportTypeArry);
    }

    @Override
    public CustomerAddressVo getCustomerAddressVO(String addressId, int[] transportType) throws Exception {
        return this.buildAddressVO(this.getCustomerAddress(addressId), transportType);
    }

    @Override
    public CustomerAddressVo buildAddressVO(CustomerAddressEntity entity, int[] transportTypeArry) throws Exception {
        CustomerAddressVo addressVo = new CustomerAddressVo();
        ObjectConvert.fatherConvertToChild((Object)entity, (Object)addressVo);
        addressVo.setEnable(true);
        addressVo.setSpeedUp("0");
        List<MallAreaEntity> mallAreaEntityList = this.getAreaErp(null, String.valueOf(addressVo.getAreaId()), null);
        if (mallAreaEntityList != null && mallAreaEntityList.size() > 0) {
            for (MallAreaEntity mallAreaEntity : mallAreaEntityList) {
                int status = mallAreaEntity.getStatus();
                int ordinaryStatus = mallAreaEntity.getOrdinaryStatus();
                if (transportTypeArry == null) continue;
                for (int i = 0; i < transportTypeArry.length; ++i) {
                    int transportTypeArryValue = transportTypeArry[i];
                    this.logger.info("======getCustomerDefaultAddress.transportTypeArryValue======transportTypeArryValue={}", (Object)transportTypeArryValue);
                    if (transportTypeArryValue == 1) {
                        if (status == 1) {
                            addressVo.setEnable(true);
                        } else {
                            addressVo.setEnable(false);
                        }
                    }
                    if (transportTypeArryValue != 2) continue;
                    if (ordinaryStatus == 1) {
                        addressVo.setEnable(true);
                        continue;
                    }
                    addressVo.setEnable(false);
                }
            }
        } else {
            addressVo.setEnable(false);
        }
        return addressVo;
    }

    @Override
    public List<SysProvinceCityAreaVo> getProvinceCityArea(int transportType, int platformGroupId) {
        List<AreaCityProvinceVo> ls = this.customerAddressMapper.getAllAreaCityProvince(transportType);
        ArrayList<SysProvinceCityAreaVo> rs = new ArrayList<SysProvinceCityAreaVo>();
        ls.stream().collect(Collectors.groupingBy(o -> o.getProvinceId())).entrySet().forEach(integerListEntry -> {
            if (integerListEntry.getValue() != null && ((List)integerListEntry.getValue()).size() > 0) {
                SysProvinceCityAreaVo sysProvinceCityAreaVo = new SysProvinceCityAreaVo();
                sysProvinceCityAreaVo.setProvinceId(((AreaCityProvinceVo)((List)integerListEntry.getValue()).get(0)).getProvinceId());
                sysProvinceCityAreaVo.setProvinceName(((AreaCityProvinceVo)((List)integerListEntry.getValue()).get(0)).getProvinceName());
                ArrayList<SysCityAreaVo> cityVoList = new ArrayList<SysCityAreaVo>();
                ((List)integerListEntry.getValue()).stream().collect(Collectors.groupingBy(o1 -> o1.getCityId())).entrySet().forEach(integerListEntry1 -> {
                    if (integerListEntry1.getValue() != null && ((List)integerListEntry1.getValue()).size() > 0) {
                        SysCityAreaVo sysCityAreaVo = new SysCityAreaVo();
                        sysCityAreaVo.setCityId(((AreaCityProvinceVo)((List)integerListEntry1.getValue()).get(0)).getCityId());
                        sysCityAreaVo.setCityName(((AreaCityProvinceVo)((List)integerListEntry1.getValue()).get(0)).getCityName());
                        ArrayList<SysAreaVo> areaVoList = new ArrayList<SysAreaVo>();
                        ((List)integerListEntry1.getValue()).stream().collect(Collectors.groupingBy(o2 -> o2.getAreaId())).entrySet().forEach(integerListEntry2 -> {
                            if (integerListEntry2.getValue() != null && ((List)integerListEntry2.getValue()).size() > 0) {
                                SysAreaVo sysAreaVo = new SysAreaVo();
                                sysAreaVo.setAreaId(((AreaCityProvinceVo)((List)integerListEntry2.getValue()).get(0)).getAreaId());
                                sysAreaVo.setAreaName(((AreaCityProvinceVo)((List)integerListEntry2.getValue()).get(0)).getAreaName());
                                areaVoList.add(sysAreaVo);
                            }
                        });
                        areaVoList.sort((o1, o2) -> o1.getAreaId() - o2.getAreaId());
                        sysCityAreaVo.setAreaVoList(areaVoList);
                        cityVoList.add(sysCityAreaVo);
                    }
                });
                cityVoList.sort((o1, o2) -> o1.getCityId() - o2.getCityId());
                sysProvinceCityAreaVo.setCityVoList(cityVoList);
                rs.add(sysProvinceCityAreaVo);
            }
        });
        rs.sort((o1, o2) -> o1.getProvinceId() - o2.getProvinceId());
        return rs;
    }

    @Override
    public List<MallTreeVo> getProvinceCity(int platformGroupId, int transportType) {
        List<SysProvinceCityAreaVo> provinceVos = this.getProvinceCityErpThr(-1, 0);
        ArrayList<MallTreeVo> treeVos = new ArrayList<MallTreeVo>();
        if (provinceVos != null && provinceVos.size() > 0) {
            for (SysProvinceCityAreaVo p : provinceVos) {
                MallTreeVo treeVo = new MallTreeVo();
                treeVo.setId(String.valueOf(p.getProvinceId()));
                treeVo.setName(p.getProvinceName());
                treeVo.setpId("");
                treeVo.setRemark("");
                treeVo.setLeaf(0);
                treeVos.add(treeVo);
                for (SysCityAreaVo c : p.getCityVoList()) {
                    treeVo = new MallTreeVo();
                    treeVo.setId(String.valueOf(c.getCityId()));
                    treeVo.setName(c.getCityName());
                    treeVo.setpId(String.valueOf(p.getProvinceId()));
                    treeVo.setRemark("");
                    treeVo.setLeaf(1);
                    treeVos.add(treeVo);
                }
            }
        }
        return TreeBuilder.builder(treeVos);
    }

    @Override
    public String getCityNamesByIds(String cityIds) {
        List<MallCityEntity> cityEntities = this.customerAddressMapper.getCityNamesByIds(cityIds.split(","));
        if (cityEntities != null && cityEntities.size() > 0) {
            return org.apache.commons.lang3.StringUtils.join((Object[])cityEntities.stream().map(c -> c.getCityName()).toArray(), (String)",");
        }
        return "";
    }

    @Override
    public Map getProvinceCityAreaByErp(Integer transportType, Integer isLongPeriodBuy) {
        List<SysProvinceCityAreaVo> sysProvinceCityAreaVoList = this.getProvinceCityErpThr(transportType, isLongPeriodBuy);
        HashMap<String, List<SysProvinceCityAreaVo>> map = new HashMap<String, List<SysProvinceCityAreaVo>>();
        map.put("provinceVoList", sysProvinceCityAreaVoList);
        return map;
    }

    private List<SysProvinceCityAreaVo> getProvinceCityErpThr(Integer transportType, Integer isLongPeriodBuy) {
        boolean success;
        int nomalStatus = 0;
        int coldStatus = 0;
        int freshStatus = 0;
        if (isLongPeriodBuy == 1) {
            coldStatus = 1;
        } else {
            if (transportType == 1 || transportType == 3) {
                coldStatus = 1;
                freshStatus = 1;
            }
            if (transportType == 2) {
                nomalStatus = 1;
            }
            if (transportType == -1) {
                nomalStatus = 1;
                coldStatus = 1;
                freshStatus = 1;
            }
        }
        HashMap<String, Integer> mapParam = new HashMap<String, Integer>();
        mapParam.put("nomalStatus", nomalStatus);
        mapParam.put("coldStatus", coldStatus);
        mapParam.put("freshStatus", freshStatus);
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.provinceAreaListUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        JSONObject jsonObject = JSON.parseObject((String)result);
        int status = (Integer)jsonObject.get((Object)"status");
        HashMap map = new HashMap();
        List<SysProvinceCityAreaVo> sysProvinceCityAreaVoList = new ArrayList<SysProvinceCityAreaVo>();
        if (status == 200 && (success = ((Boolean)jsonObject.get((Object)"success")).booleanValue())) {
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"result");
            sysProvinceCityAreaVoList = JSON.parseArray((String)jsonArray.toJSONString(), SysProvinceCityAreaVo.class);
            sysProvinceCityAreaVoList.sort((o1, o2) -> o1.getProvinceId() - o2.getProvinceId());
        }
        return sysProvinceCityAreaVoList;
    }

    @Override
    public BaseJsonVo getAreaIsOpen(Integer areaId) {
        BaseJsonVo baseJsonVo = this.areaService.getAreaIsOpen(areaId);
        return baseJsonVo;
    }
}

