/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.redpackage.RedpackageInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="confirmGoods")
public class ConfirmGoodsListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallDataSyncInterface syncInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private RedpackageInterface redpackageService;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    @Lazy
    private ActiveInterface activeInterface;
    @Autowired
    private ActiveSaleContext activeContext;
    @Autowired
    private PrepayCardPlanDetailInterface planDetailInterface;

    public boolean receive(Message message, ConsumeContext context) {
        try {
            Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
            String orderMainNo = param.get("orderMainNo").toString();
            String orderNo = param.get("orderNo").toString();
            String customerId = param.get("userId").toString();
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            try {
                this.redpackageService.confirmOrder(orderMainEntity);
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u7ea2\u5305\u786e\u8ba4\u6536\u8d27\u51fa\u9519", (Throwable)e);
            }
            try {
                if (StringUtils.isNotEmpty((String)orderMainEntity.getBindCode())) {
                    ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(orderMainEntity.getBindCode());
                    this.activeContext.confirmOrder(activeEntity.getActiveType(), orderMainEntity);
                }
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u8bb0\u5f55\u9080\u8bf7\u51fa\u9519", (Throwable)e);
            }
            try {
                this.vipService.customerLevelUp(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo());
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u4f1a\u5458\u5347\u7ea7\u51fa\u9519", (Throwable)e);
            }
            try {
                this.vipService.finishAllTasksByFinishOrder(orderMainNo, orderMainEntity.getCustomerId());
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u4f1a\u5458\u8ba2\u5355\u7c7b\u4efb\u52a1\u51fa\u9519", (Throwable)e);
            }
            try {
                this.syncInterface.producerData(orderMainNo, DataSyncTypeEnum.BI_MAIN_ORDER, "confirmGoods");
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-BI\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            try {
                this.orderService.confirmOrder(orderNo);
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u7b7e\u6536\u72b6\u6001\u63a8\u9001\u81f3EDB\u51fa\u9519", (Throwable)e);
            }
            if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue()) {
                this.planDetailInterface.orderConfirmGoodsUpdateCardPlanStatus(orderMainNo);
            }
        }
        catch (Exception e) {
            this.log.error("\u6d88\u8d39\u6d88\u606fconfirmGoods\u5f02\u5e38\uff0c" + e.getMessage());
        }
        return true;
    }
}

