/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.prepay.PrepayCardBaseVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardDo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardInfo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanRefundlVo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.DeliverNewErpInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardLogInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanLogInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PrepayCardOrderPlanService
implements PrepayCardOrderPlanInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;
    @Autowired
    private PrepayCardInterface prepayCardService;
    @Autowired
    private PrepayCardLogInterface prepayCardLogService;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchService;
    @Autowired
    private CustomerAddressInterface customerAddressService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private PrepayCardPlanLogInterface prepayCardPlanLogService;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Autowired
    private DeliverNewErpInterface deliverNewErpInterface;
    @Autowired
    private MallRedisLock mallRedisLock;

    @Override
    public BaseJsonVo getCardInfo(String orderNo) {
        PrepayCardInfo prepayCardInfo = new PrepayCardInfo();
        PrepayCardEntity query = new PrepayCardEntity();
        query.setOrderMainNo(orderNo);
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.getSingle(query, 0L);
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5976\u5361\u8ba2\u5355!");
        }
        if (prepayCardEntity.getRemainCount() < 1) {
            return BaseJsonVo.error((String)"\u5361\u8ba2\u5355\u65e0\u53ef\u9000\u91d1\u989d!");
        }
        BeanUtils.copyProperties((Object)prepayCardEntity, (Object)prepayCardInfo);
        PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(prepayCardEntity.getBatchId(), 0L);
        prepayCardInfo.setPerPrice(prepayCardBatchEntity.getPerPrice());
        return BaseJsonVo.success((Object)prepayCardInfo);
    }

    @Override
    public BaseJsonVo deleteOrderPlan(Integer detailedId, String customerId) {
        PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey(detailedId, 0L);
        BaseJsonVo x = this.checkOrderPlan(prepayCardDetailEntity, customerId, "\u65e0\u6cd5\u5220\u9664");
        if (!x.isSuccess()) {
            return x;
        }
        return this.prepayCardPlanDetailService.deletePlanOrder(prepayCardDetailEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrderPlan(PrepayCardDo prepayCardDo, String customerId) {
        PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey(prepayCardDo.getDetailedId());
        BaseJsonVo x = this.checkOrderPlan(prepayCardDetailEntity, customerId, "\u65e0\u6cd5\u4fee\u6539");
        if (!x.isSuccess()) {
            return x;
        }
        this.logger.info("\u8ba1\u5212\u4fee\u6539\u53c2\u6570:{}", (Object)prepayCardDo);
        prepayCardDetailEntity.setPickTime(this.getFirstDeliveryDate(prepayCardDo));
        prepayCardDetailEntity.setAddrId(prepayCardDo.getAddrId());
        prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
        PrepayCardDetailEntity update = new PrepayCardDetailEntity();
        update.setDetailedId(prepayCardDetailEntity.getDetailedId());
        update.setAddrId(prepayCardDo.getAddrId());
        update.setPickTime(prepayCardDetailEntity.getPickTime());
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.SUSPEND.getValue()) {
            update.setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
        }
        if (this.prepayCardPlanDetailService.updateByPrimaryKeySelective(update) > 0) {
            x = this.prepayCardPlanDetailService.editPlanOrder(prepayCardDetailEntity);
            this.logger.info("\u8ba1\u5212:{},\u4fee\u6539:{}", (Object)prepayCardDetailEntity, (Object)x.isSuccess());
            if (!x.isSuccess()) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return x;
            }
        }
        return BaseJsonVo.success((Object)"\u8ba1\u5212\u4fee\u6539\u6210\u529f");
    }

    private BaseJsonVo checkOrderPlan(PrepayCardDetailEntity prepayCardDetailEntity, String customerId, String message) {
        if (prepayCardDetailEntity == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u8ba1\u5212");
        }
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.DELIVERY.getValue() && (prepayCardDetailEntity.getPickTime().before(DateUtils.currentDate()) || prepayCardDetailEntity.getPickTime().equals(DateUtils.currentDate()))) {
            return BaseJsonVo.error((String)("\u8ba2\u5355\u914d\u9001\u4e2d," + message));
        }
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212\u5df2\u9000\u6b3e," + message));
        }
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212\u5df2\u5b8c\u6210," + message));
        }
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212\u672a\u5b8c\u6210," + message));
        }
        if (!prepayCardDetailEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)("\u672a\u77e5\u7684\u8ba1\u5212," + message));
        }
        PrepayCardEntity result = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardDetailEntity.getCardId()));
        if (result == null) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u4e0d\u5b58\u5728");
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212\u5df2\u5b8c\u6210," + message));
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)("\u5361\u5df2\u9000\u6b3e," + message));
        }
        if (result.getEndTime() != null && result.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u5361\u5df2\u8fc7\u671f," + message));
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getOrderPlanDetail(Integer planId) {
        PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey(planId);
        return BaseJsonVo.success((Object)(prepayCardDetailEntity == null ? BaseJsonVo.error((String)"\u65e0\u6548\u7684\u914d\u9001\u8ba1\u5212") : prepayCardDetailEntity.getPerPrice()));
    }

    @Override
    public BaseJsonVo refundOrderPlan(String orderMainNo, int orderSource, String planIds, BigDecimal amount, String operator) {
        this.logger.info("\u5f00\u59cb\u8c03\u7528\u9884\u4ed8\u5361\u9000\u6b21\u6570:\u8ba2\u5355\u53f7{},\u8ba2\u5355\u7c7b\u578b:{},\u8ba1\u5212id:{},\u91d1\u989d:{},\u64cd\u4f5c\u4eba:{}", new Object[]{orderMainNo, orderSource, planIds, amount, operator});
        if (StringUtils.isEmpty((String)orderMainNo)) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        if (orderSource == OrderSourceEnum.CARDPLAN.getValue()) {
            PrepayCardDetailEntity query = new PrepayCardDetailEntity();
            query.setOrderMainNo(orderMainNo);
            PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.getSingle(query, 0L);
            if (prepayCardDetailEntity == null) {
                return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u914d\u9001\u8ba1\u5212\u8ba2\u5355");
            }
            baseJsonVo = this.prepayCardOrderPlanService.refundOrderNum(prepayCardDetailEntity, amount, operator);
            if (baseJsonVo.isSuccess()) {
                this.prepayCardService.setCardStatus(prepayCardDetailEntity.getCardId());
            }
        } else if (orderSource == OrderSourceEnum.CARD_PREPAY.getValue()) {
            PrepayCardEntity query = new PrepayCardEntity();
            query.setOrderMainNo(orderMainNo);
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.getSingle(query, 0L);
            if (prepayCardEntity == null) {
                return BaseJsonVo.error((String)("\u65e0\u6548\u7684\u5361\u8ba2\u5355" + orderMainNo));
            }
            baseJsonVo = this.prepayCardOrderPlanService.refundCardNum(prepayCardEntity, planIds, amount, operator);
        } else {
            return BaseJsonVo.error((String)"orderSource \u53c2\u6570\u503c\u4e0d\u6b63\u786e");
        }
        return baseJsonVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo refundCardNum(PrepayCardEntity prepayCardEntity, String planIds, BigDecimal amount, String operator) {
        int result = 0;
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)("\u9000\u5361\u5931\u8d25,\u5361" + PrepayCardStatusEnum.getName(prepayCardEntity.getStatus()) + "\uff0c\u8bf7\u53bb\u9000\u5b9e\u7269\u8ba2\u5355!"));
        }
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)("\u9000\u5361\u5931\u8d25,\u5361" + PrepayCardStatusEnum.getName(prepayCardEntity.getStatus()) + "\uff0c\u8bf7\u53bb\u9000\u5b9e\u7269\u8ba2\u5355!"));
        }
        PrepayCardEntity update = new PrepayCardEntity();
        update.setCardId(prepayCardEntity.getCardId());
        update.setRemainCount(0);
        result = this.prepayCardService.updateByPrimaryKeySelective(update);
        this.prepayCardLogService.saveCardPlanLog(prepayCardEntity.getCardId(), prepayCardEntity.getStatus(), PrepayCardStatusEnum.NOEFFECT.getValue(), operator + "\u7528\u6237\u9000\u5361,\u4f59\u989d:" + amount);
        if (result > 0) {
            this.logger.info("\u5976\u5361\u5361\u53f7:{},\u91d1\u989d:{},\u9000\u6b3e\u4eba:{}", new Object[]{prepayCardEntity.getRelateCardNo(), amount, operator});
            BaseJsonVo<BalanceChangeDTO> baseJsonVo = new BaseJsonVo<BalanceChangeDTO>();
            try {
                baseJsonVo = this.accountBalanceInterface.cardRefund(prepayCardEntity.getRelateCardNo(), "", amount, operator);
                this.logger.info("\u5976\u5361\u5361\u53f7:{},\u91d1\u989d:{},\u9000\u6b3e\u4eba:{},\u9000\u6b3e\u72b6\u6001:{}", new Object[]{prepayCardEntity.getRelateCardNo(), amount, operator, baseJsonVo.isSuccess()});
                if (!baseJsonVo.isSuccess()) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                }
            }
            catch (NoTransactionException e) {
                e.printStackTrace();
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u914d\u9001\u6b21\u6570\u9000\u8ba2\u5931\u8d25");
            }
            return baseJsonVo.isSuccess() ? BaseJsonVo.success((Object)"\u5df2\u9000") : BaseJsonVo.error((String)"\u914d\u9001\u6b21\u6570\u9000\u8ba2\u5931\u8d25");
        }
        return BaseJsonVo.error((String)"\u914d\u9001\u6b21\u6570\u9000\u8ba2\u5931\u8d25");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo refundOrderNum(PrepayCardDetailEntity prepayCardDetailEntity, BigDecimal amount, String operator) {
        if (amount.compareTo(prepayCardDetailEntity.getPerPrice()) == 0) {
            PrepayCardDetailEntity update = new PrepayCardDetailEntity();
            update.setDetailedId(prepayCardDetailEntity.getDetailedId());
            update.setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
            this.prepayCardPlanDetailService.updateByPrimaryKeySelective(update);
        }
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardDetailEntity.getCardId()));
        try {
            this.logger.info("\u5976\u5361\u5361\u53f7:{},\u91d1\u989d:{},\u9000\u6b3e\u4eba:{}", new Object[]{prepayCardEntity.getRelateCardNo(), amount, operator});
            BaseJsonVo<BalanceChangeDTO> baseJsonVo = this.accountBalanceInterface.cardRefund(prepayCardEntity.getRelateCardNo(), prepayCardDetailEntity.getOrderMainNo(), amount, operator);
            this.logger.info("\u5976\u5361\u5361\u53f7:{},\u91d1\u989d:{},\u9000\u6b3e\u4eba:{},\u4f59\u989d\u9000\u6b3e\u72b6\u6001:{}", new Object[]{prepayCardEntity.getRelateCardNo(), amount, operator, baseJsonVo.isSuccess()});
            if (!baseJsonVo.isSuccess()) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)("\u914d\u9001\u6b21\u6570\u9000\u8ba2\u5931\u8d25," + baseJsonVo.getMessage()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u9000\u5976\u5361\u4f59\u989d\u51fa\u9519,\u5361\u53f7:{},\u8ba2\u5355\u53f7:{},\u91d1\u989d:{},\u9000\u6b3e\u4eba:{}", new Object[]{prepayCardEntity.getRelateCardNo(), prepayCardDetailEntity.getOrderMainNo(), amount, operator});
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u914d\u9001\u6b21\u6570\u9000\u8ba2\u5931\u8d25");
        }
        this.prepayCardPlanLogService.saveCardPlanLog(prepayCardDetailEntity.getDetailedId(), "\u7528\u6237:" + operator + "\u9000\u8ba2\u8ba1\u5212:" + prepayCardDetailEntity.getDetailedId() + ",\u72b6\u6001:\u6210\u529f", 1);
        return BaseJsonVo.success((Object)"\u6210\u529f\u9000\u8ba2\u914d\u9001\u6b21\u6570");
    }

    @Override
    public BaseJsonVo getOrderPlanList(String orderMainNo) {
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        prepayCardDetailEntity.setCardOrderMainNo(orderMainNo);
        ArrayList refundlVoList = new ArrayList();
        List list = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
        if (list.size() > 0) {
            list.forEach(p -> {
                if (StringUtils.isEmpty((String)p.getOrderMainNo()) && p.getStatus().intValue() != PrepayCardPlanStatusEnum.NOEFFECT.getValue()) {
                    PrepayCardPlanRefundlVo prepayCardPlanRefundlVo = new PrepayCardPlanRefundlVo();
                    BeanUtils.copyProperties((Object)p, (Object)prepayCardPlanRefundlVo);
                    refundlVoList.add(prepayCardPlanRefundlVo);
                }
            });
        }
        return BaseJsonVo.success(refundlVoList);
    }

    @Override
    public List<PrepayCardBaseVo> getMyCardList(String customerId) {
        PrepayCardEntity prepayCardEntity = new PrepayCardEntity();
        prepayCardEntity.setBelongCustomerId(customerId);
        List list = this.prepayCardService.getList(prepayCardEntity, 0L);
        ArrayList<PrepayCardBaseVo> result = new ArrayList<PrepayCardBaseVo>();
        if (list.size() > 0) {
            list.forEach(c -> {
                PrepayCardBaseVo prepayCardBaseVo = new PrepayCardBaseVo();
                BeanUtils.copyProperties((Object)c, (Object)prepayCardBaseVo);
                PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(c.getBatchId());
                prepayCardBaseVo.setBatchName(prepayCardBatchEntity.getBatchName());
                prepayCardBaseVo.setTitle(prepayCardBatchEntity.getTitle());
                if (c.getEndTime() != null && c.getEndTime().before(DateUtils.now())) {
                    prepayCardBaseVo.setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
                }
                prepayCardBaseVo.setStatusName(PrepayCardStatusEnum.getName(prepayCardBaseVo.getStatus()));
                PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
                prepayCardDetailEntity.setCardId(c.getCardId());
                List detailList = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
                Integer noDeliveryNum = 0;
                if (detailList.size() > 0) {
                    for (int j = 0; j < detailList.size(); ++j) {
                        if (((PrepayCardDetailEntity)detailList.get(j)).getStatus().intValue() != PrepayCardPlanStatusEnum.DELIVERY.getValue() || !((PrepayCardDetailEntity)detailList.get(j)).getPickTime().after(DateUtils.currentDate())) continue;
                        noDeliveryNum = noDeliveryNum + ((PrepayCardDetailEntity)detailList.get(j)).getQuantity();
                    }
                    prepayCardBaseVo.setNoDeliveryNum(noDeliveryNum);
                } else {
                    prepayCardBaseVo.setNoDeliveryNum(noDeliveryNum);
                }
                Map<String, List<String>> pics = this.picService.getProductPicUrlMap(String.valueOf(c.getBatchId()), SalesTypeEnum.SALES_PRODUCT.getValue());
                if (pics != null && pics.containsKey("picProductHead") && pics.get("picProductHead") != null && pics.get("picProductHead").size() > 0) {
                    prepayCardBaseVo.setPic(pics.get("picProductHead").get(0));
                }
                result.add(prepayCardBaseVo);
            });
            result.sort(new Comparator<PrepayCardBaseVo>(){

                @Override
                public int compare(PrepayCardBaseVo o1, PrepayCardBaseVo o2) {
                    return o2.getCardId().compareTo(o1.getCardId());
                }
            });
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveDeliverRule(PrepayCardDo prepayCardDo) {
        PrepayCardEntity prepayCardEntity = new PrepayCardEntity();
        BeanUtils.copyProperties((Object)prepayCardDo, (Object)prepayCardEntity);
        PrepayCardEntity result = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardEntity.getCardId()), 0L);
        BaseJsonVo x = this.checkCard(prepayCardDo, prepayCardEntity, result);
        if (!x.isSuccess()) {
            return x;
        }
        String message = "\u521b\u5efa\u6210\u529f";
        ArrayList<PrepayCardDetailEntity> list = new ArrayList<PrepayCardDetailEntity>();
        if (result.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue()) {
            prepayCardEntity.setEndTime(this.LocalDateTodate(this.getLocalDate(DateUtils.now()).plusMonths(result.getTotalCount() * 2)));
            message = "\u521b\u5efa\u6210\u529f";
        }
        prepayCardEntity.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
        prepayCardEntity.setFirstDate(this.getFirstDeliveryDate(prepayCardDo));
        if (prepayCardDo.getMonth() == 0) {
            prepayCardEntity.setRemainCount(prepayCardDo.getRemainCount() == null ? result.getRemainCount() : prepayCardDo.getRemainCount());
        } else {
            prepayCardEntity.setRemainCount(prepayCardDo.getNumber());
        }
        int resultNum = this.prepayCardService.updateCardCount(prepayCardEntity);
        if (resultNum == 0) {
            return BaseJsonVo.error((String)"\u5269\u4f59\u7bb1\u6570\u4e0d\u8db3!\u8ba1\u5212\u521b\u5efa\u5931\u8d25!");
        }
        this.prepayCardLogService.saveCardPlanLog(prepayCardEntity.getCardId(), result.getStatus(), PrepayCardStatusEnum.ACTIVE.getValue(), "\u7528\u6237\u4fdd\u5b58\u914d\u9001\u89c4\u5219");
        if (result.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue() || result.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
            if (result.getRemainCount() > 0) {
                int resultNum2;
                list = new ArrayList();
                PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
                BeanUtils.copyProperties((Object)result, (Object)prepayCardDetailEntity);
                prepayCardDetailEntity.setOrderMainNo("");
                prepayCardDetailEntity.setCardOrderMainNo(result.getOrderMainNo());
                prepayCardDetailEntity.setCreateTime(DateUtils.now());
                prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
                prepayCardDetailEntity.setCustomerId(result.getBelongCustomerId());
                prepayCardDetailEntity.setOrderSource(OrderSourceEnum.CARDPLAN.getValue());
                prepayCardDetailEntity.setAddrId(prepayCardEntity.getAddrId());
                PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(result.getBatchId());
                prepayCardDetailEntity.setPromotionId(prepayCardBatchEntity.getProductPromotionId());
                prepayCardDetailEntity.setPickTime(prepayCardEntity.getFirstDate());
                prepayCardDetailEntity.setQuantity(prepayCardDo.getNumber());
                prepayCardDetailEntity.setPerPrice(prepayCardBatchEntity.getPerPrice().multiply(new BigDecimal(prepayCardDo.getNumber())));
                list.add(prepayCardDetailEntity);
                this.logger.info(prepayCardEntity.toString());
                if (prepayCardDo.getMonth() == 0) {
                    boolean isSameDeliveryNum = result.getRemainCount() % prepayCardDo.getNumber() == 0;
                    Integer deliveryNum = isSameDeliveryNum ? result.getRemainCount() / prepayCardDo.getNumber() : result.getRemainCount() / prepayCardDo.getNumber() + 1;
                    this.getPrepayCardDetailEntity(list, prepayCardDetailEntity, prepayCardEntity.getPeriodType(), prepayCardEntity.getPeriod(), deliveryNum - 1);
                    list.forEach(d -> {
                        d.setQuantity((int)prepayCardDo.getNumber());
                        d.setPerPrice(prepayCardBatchEntity.getPerPrice().multiply(new BigDecimal(d.getQuantity())));
                    });
                    if (!isSameDeliveryNum) {
                        ((PrepayCardDetailEntity)list.get(list.size() - 1)).setQuantity(result.getRemainCount() % prepayCardDo.getNumber());
                        ((PrepayCardDetailEntity)list.get(list.size() - 1)).setPerPrice(prepayCardBatchEntity.getPerPrice().multiply(new BigDecimal(((PrepayCardDetailEntity)list.get(list.size() - 1)).getQuantity())));
                    }
                }
                if ((resultNum2 = this.prepayCardPlanDetailService.batchInsert(list)) == 0) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return BaseJsonVo.error((String)"\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                PrepayCardDetailEntity queryTemp = new PrepayCardDetailEntity();
                queryTemp.setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
                queryTemp.setCardId(result.getCardId());
                List tempList = this.prepayCardPlanDetailService.getList(queryTemp);
                BaseJsonVo baseJsonVo = this.prepayCardPlanDetailService.createPlanOrder((PrepayCardDetailEntity)tempList.get(0));
                this.logger.info("\u8ba1\u5212:{},\u521b\u5efa\u8ba2\u5355:{},{}", new Object[]{tempList.get(0), baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
                if (!baseJsonVo.isSuccess()) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return BaseJsonVo.error((String)(baseJsonVo.getMessage() + ",\u521b\u5efa\u5931\u8d25!"));
                }
                return BaseJsonVo.success((Object)message);
            }
            return BaseJsonVo.error((String)"\u53ef\u7528\u6b21\u6570\u4e0d\u8db3,\u521b\u5efa\u5931\u8d25!");
        }
        return BaseJsonVo.success((Object)message);
    }

    private BaseJsonVo checkCard(PrepayCardDo prepayCardDo, PrepayCardEntity prepayCardEntity, PrepayCardEntity result) {
        if (prepayCardEntity.getPeriod() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u914d\u9001\u54ea\u4e00\u5929\u914d\u9001!");
        }
        if (prepayCardEntity.getPeriod() < 1 || prepayCardEntity.getPeriod() > 31) {
            return BaseJsonVo.error((String)"\u914d\u9001\u5929\u5fc5\u987b\u57281\u53f7\u523031\u53f7\u4e4b\u95f4!");
        }
        if (StringUtils.isEmpty((String)prepayCardEntity.getAddrId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u914d\u9001\u5730\u5740!");
        }
        if (result == null) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u4e0d\u5b58\u5728");
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)"\u914d\u9001\u8ba1\u5212\u5df2\u5b8c\u6210,\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u9000\u6b3e,\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getEndTime() != null && result.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u8fc7\u671f,\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getRemainCount() == 0) {
            return BaseJsonVo.error((String)"\u5269\u4f59\u7bb1\u6570\u4e3a0\uff0c\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getRemainCount() < prepayCardDo.getNumber()) {
            return BaseJsonVo.error((String)("\u5269\u4f59\u7bb1\u6570" + result.getRemainCount() + "\u5c0f\u4e8e\u914d\u7f6e\u7bb1\u6570" + prepayCardDo.getNumber() + ",\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public MallShoppingcartVO buildMallShoppingcartVO(PrepayCardEntity prepayCardEntity, PrepayCardBatchEntity prepayCardBatchEntity) {
        MallPromotionVO promotionVO;
        int transportType = this.promotionService.getPromotionDeliveryType(prepayCardBatchEntity.getProductPromotionId());
        int[] arr = new int[]{transportType};
        MallShoppingcartVO shoppingcartVO = new MallShoppingcartVO();
        shoppingcartVO.setPromotions(new ArrayList<MallPromotionVO>());
        shoppingcartVO.setOrderSource(OrderSourceEnum.CARDPLAN.getValue());
        BaseJsonVo result = this.promotionService.buildPromotionVO(prepayCardBatchEntity.getProductPromotionId(), prepayCardBatchEntity.getProCount(), true);
        if (result.isSuccess() && (promotionVO = (MallPromotionVO)result.getValue()).getValid().booleanValue()) {
            shoppingcartVO.getPromotions().add(promotionVO);
            ArrayList<MallProductVO> productPool = new ArrayList<MallProductVO>();
            for (MallPromotionVO vo : shoppingcartVO.getPromotions()) {
                if (vo == null) continue;
                if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(vo.getProductType()).intValue()) {
                    if (vo.getProduct() == null) continue;
                    vo.getProduct().setValid(vo.getValid());
                    vo.getProduct().setPromotionName(vo.getPromotionName());
                    vo.getProduct().setPromotionId(vo.getPromotionId());
                    productPool.add(vo.getProduct());
                    continue;
                }
                if (SalesTypeEnum.SALES_GROUP.getValue() != Integer.valueOf(vo.getProductType()).intValue() || vo.getGroup() == null) continue;
                for (MallProductVO proVO : vo.getGroup().getProductList()) {
                    proVO.setValid(vo.getValid());
                    proVO.setPromotionId(vo.getPromotionId());
                    proVO.setPromotionName(vo.getPromotionName());
                    productPool.add(proVO);
                }
            }
            shoppingcartVO.setProductsPool(productPool);
        }
        return shoppingcartVO;
    }

    @Override
    public CustomerAddressVo getCustomerAddressVo(PrepayCardBatchEntity prepayCardBatchEntity, PrepayCardEntity prepayCardEntity) {
        int transportType = this.promotionService.getPromotionDeliveryType(prepayCardBatchEntity.getProductPromotionId());
        int[] arr = new int[]{transportType};
        MallShoppingcartVO shoppingcartVO = new MallShoppingcartVO();
        shoppingcartVO.setPromotions(new ArrayList<MallPromotionVO>());
        shoppingcartVO.setOrderSource(OrderSourceEnum.CARDPLAN.getValue());
        try {
            return this.customerAddressService.getCustomerAddressVO(prepayCardEntity.getAddrId(), arr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<PrepayCardDetailEntity> getPrepayCardDetailEntity(List<PrepayCardDetailEntity> list, PrepayCardDetailEntity prepayCardDetailEntity, int periodType, Integer period, Integer remainCount) {
        if (list.size() > remainCount) {
            return list;
        }
        PrepayCardDetailEntity result = new PrepayCardDetailEntity();
        BeanUtils.copyProperties((Object)prepayCardDetailEntity, (Object)result);
        Date nextDeliverDate = this.LocalDateTodate(this.getNextDeliveryDate(this.getLocalDate(prepayCardDetailEntity.getPickTime()), periodType, period, false));
        this.logger.info("\u7b2c{}\u6b21\u914d\u9001\u65f6\u95f4:{}", (Object)list.size(), (Object)nextDeliverDate);
        result.setPickTime(nextDeliverDate);
        list.add(result);
        return this.getPrepayCardDetailEntity(list, result, periodType, period, remainCount);
    }

    private Date LocalDateTodate(LocalDate localDate) {
        if (localDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        return null;
    }

    private LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    @Override
    public Date getFirstDeliveryDate(int periodType, Integer period) {
        return this.LocalDateTodate(this.getNextDeliveryDate(LocalDate.now(), periodType, period, true));
    }

    @Override
    public Date getFirstDeliveryDate(int month, int periodType, Integer period) {
        LocalDate localDate = LocalDate.of(LocalDate.now().getYear(), month, (int)period);
        if (LocalDate.now().getMonth().getValue() > month || LocalDate.now().getMonth().getValue() == month && LocalDate.now().getDayOfMonth() >= period) {
            localDate = localDate.plusYears(1L);
        }
        return this.LocalDateTodate(localDate);
    }

    private Date getFirstDeliveryDate(PrepayCardDo prepayCardDo) {
        if (prepayCardDo.getMonth() == 0) {
            return this.getFirstDeliveryDate(prepayCardDo.getPeriodType(), prepayCardDo.getPeriod());
        }
        return this.getFirstDeliveryDate(prepayCardDo.getMonth(), prepayCardDo.getPeriodType(), prepayCardDo.getPeriod());
    }

    @Override
    public BaseJsonVo<Date> getFirstDeliveryDate(String customerId, String cardId, int periodType, Integer period, String addrId) {
        PrepayCardEntity prepayCardEntity = new PrepayCardEntity();
        prepayCardEntity.setBelongCustomerId(customerId);
        prepayCardEntity.setCardId(cardId);
        prepayCardEntity.setPeriod(period);
        prepayCardEntity.setPeriodType(periodType);
        prepayCardEntity.setAddrId(addrId);
        return BaseJsonVo.success((Object)this.getFirstDeliveryDate(prepayCardEntity.getPeriodType(), prepayCardEntity.getPeriod()));
    }

    @Override
    public BaseJsonVo<Date> getFirstDeliveryDate(PrepayCardEntity prepayCardEntity) {
        Date deliveryDate = this.getFirstDeliveryDate(prepayCardEntity.getPeriodType(), prepayCardEntity.getPeriod());
        if (!deliveryDate.after(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)7))) {
            PrepayCardEntity result = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardEntity.getCardId()));
            if (result == null) {
                return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u4e0d\u5b58\u5728");
            }
            PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(result.getBatchId());
            MallShoppingcartVO shoppingcartVO = this.prepayCardOrderPlanService.buildMallShoppingcartVO(result, prepayCardBatchEntity);
            shoppingcartVO.setCustomerId(result.getBelongCustomerId());
            result.setAddrId(prepayCardEntity.getAddrId());
            CustomerAddressVo customerAddressVo = this.prepayCardOrderPlanService.getCustomerAddressVo(prepayCardBatchEntity, result);
            String deliverDateStr = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1), (String)"yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u6307\u5b9a\u65e5\u671f\u67e5\u5e93\u5b58:{}", (Object)deliverDateStr);
            String temp = this.deliverNewErpInterface.getDeliverByErpThr(shoppingcartVO, customerAddressVo, deliverDateStr, 0);
            this.logger.info("\u8c03\u7528\u53ef\u9009\u914d\u9001\u65e5\u671f\u7ed3\u679c:{}", (Object)temp);
            JSONObject jsonObject = JSON.parseObject((String)temp);
            this.logger.info("*************************getNoSeepUpProductDeliverByErp***********jsonObject************jsonObject={}", (Object)jsonObject);
            int status = (Integer)jsonObject.get((Object)"status");
            if (status == 200) {
                boolean success = (Boolean)jsonObject.get((Object)"success");
                if (success) {
                    JSONObject objectResult = (JSONObject)jsonObject.get((Object)"result");
                    JSONObject deliverDates = null;
                    JSONArray jsonArrayProduct = null;
                    deliverDates = (JSONObject)objectResult.get((Object)"dates");
                    jsonArrayProduct = (JSONArray)objectResult.get((Object)"wxProductForms");
                    this.logger.info("deliverDates:[]", (Object)objectResult.get((Object)"deliverDates").toString());
                    if (objectResult.get((Object)"deliverDates") != null && objectResult.get((Object)"deliverDates") != "" && !objectResult.get((Object)"deliverDates").toString().equals("[]")) {
                        return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u8bf7\u5f80\u540e\u6362\u4e2a\u65e5\u671f\u8bd5\u8bd5\uff01", DateUtils.formatDate((Date)deliveryDate, (String)"yyyy-MM-dd")));
                    }
                    String earliestPickupDate = (String)objectResult.get((Object)"earliestPickupDate");
                    deliverDates = (JSONObject)objectResult.get((Object)"dates");
                    if (deliverDates != null) {
                        ArrayList<Date> backDeliveryDateList = new ArrayList<Date>();
                        for (String k : deliverDates.keySet()) {
                            Date backDeliveryDate = DateUtils.getDateFromString((String)k.split("\\|")[0], (String)"yyyy-MM-dd");
                            backDeliveryDateList.add(backDeliveryDate);
                            if (deliveryDate.compareTo(backDeliveryDate) != 0) continue;
                            return BaseJsonVo.success((Object)deliveryDate);
                        }
                        if (deliveryDate.before((Date)backDeliveryDateList.get(0))) {
                            return BaseJsonVo.success((Object)deliveryDate);
                        }
                        return BaseJsonVo.success((Object)DateUtils.getAddDateByDay((Date)((Date)backDeliveryDateList.get(0)), (int)7));
                    }
                    return BaseJsonVo.error((String)"\u53d1\u8d27\u65e5\u671f\u8fd4\u56de\u5931\u8d25!");
                }
                return BaseJsonVo.error((String)"\u53d1\u8d27\u65e5\u671f\u8fd4\u56de\u5931\u8d25!");
            }
            return BaseJsonVo.error((String)((String)jsonObject.get((Object)"message")));
        }
        return BaseJsonVo.success((Object)deliveryDate);
    }

    private LocalDate getNextDeliveryDate(LocalDate deliverDate, int periodType, Integer period, boolean isFirstTime) {
        if (periodType == 1) {
            if (isFirstTime) {
                if (deliverDate.getYear() > LocalDate.now().getYear()) {
                    if (period < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return LocalDate.of(deliverDate.getYear(), deliverDate.getMonth(), (int)period);
                    }
                    return deliverDate.with(TemporalAdjusters.lastDayOfMonth());
                }
                if (period > LocalDate.now().getDayOfMonth() && LocalDate.now().getDayOfMonth() < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                    if (period < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return LocalDate.of(deliverDate.getYear(), deliverDate.getMonth(), (int)period);
                    }
                    return deliverDate.with(TemporalAdjusters.lastDayOfMonth());
                }
                LocalDate nextMonthDay = deliverDate.plusMonths(1L);
                if (period > nextMonthDay.getDayOfMonth()) {
                    if (period > nextMonthDay.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return nextMonthDay.with(TemporalAdjusters.lastDayOfMonth());
                    }
                    return LocalDate.of(nextMonthDay.getYear(), deliverDate.getMonth(), (int)period);
                }
                return LocalDate.of(nextMonthDay.getYear(), nextMonthDay.getMonth(), (int)period);
            }
            LocalDate nextMonthDay = deliverDate.plusMonths(1L);
            if (period > nextMonthDay.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                return nextMonthDay.with(TemporalAdjusters.lastDayOfMonth());
            }
            return LocalDate.of(nextMonthDay.getYear(), nextMonthDay.getMonth(), (int)period);
        }
        if (periodType == 2) {
            // empty if block
        }
        return null;
    }

    @Override
    @Transactional
    public BaseJsonVo suspendDeliveryPlan(String cardId) {
        PrepayCardEntity result = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)cardId));
        if (result == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u9884\u4ed8\u5361");
        }
        if (result.getStatus().intValue() == PrepayCardPlanStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u5df2\u5b8c\u6210,\u65e0\u6cd5\u6682\u505c");
        }
        if (result.getStatus().intValue() == PrepayCardPlanStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u9000\u6b3e,\u65e0\u6cd5\u6682\u505c");
        }
        if (result.getEndTime() != null && result.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u6682\u505c");
        }
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setCardId(cardId);
        List list = this.prepayCardPlanDetailService.getList(query, 0L);
        if (list.stream().anyMatch(p -> p.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue())) {
            return BaseJsonVo.error((String)"\u521a\u751f\u6210\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u6682\u505c\u8ba1\u5212\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
            try {
                BaseJsonVo baseJsonVo = this.prepayCardPlanDetailService.suspendPrepayCardPlan(cardId);
                this.prepayCardLogService.saveCardPlanLog(cardId, result.getStatus(), PrepayCardPlanStatusEnum.SUSPEND.getValue(), "\u7528\u6237\u6682\u505c\u914d\u9001\u8ba1\u5212");
                if (baseJsonVo.isSuccess()) {
                    query = new PrepayCardDetailEntity();
                    query.setCardId(cardId);
                    query.setStatus(PrepayCardPlanStatusEnum.SUSPEND.getValue());
                    list = new ArrayList();
                    list = this.prepayCardPlanDetailService.getList(query, 0L);
                    for (int i = 0; i < list.size(); ++i) {
                        BaseJsonVo tempBaseJsonVo;
                        if (!StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(i)).getOrderMainNo()) || (tempBaseJsonVo = this.prepayCardPlanDetailService.editPlanOrder((PrepayCardDetailEntity)list.get(i))).isSuccess()) continue;
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        return BaseJsonVo.error((String)("\u8ba1\u5212\u6682\u505c\u5931\u8d25\uff0c" + tempBaseJsonVo.getMessage()));
                    }
                    return BaseJsonVo.success((Object)"\u8ba1\u5212\u6682\u505c\u6210\u529f");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        } else {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u672a\u6fc0\u6d3b\uff0c\u65e0\u6cd5\u6682\u505c");
        }
        return BaseJsonVo.error((String)"\u914d\u9001\u8ba1\u5212\u6682\u505c\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getCardPlanDetail(String cardId) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)cardId), 0L);
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u5361\u65e0\u6548\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        PrepayCardDetailVo prepayCardDetailVo = new PrepayCardDetailVo();
        BeanUtils.copyProperties((Object)prepayCardEntity, (Object)prepayCardDetailVo);
        PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(prepayCardEntity.getBatchId());
        prepayCardDetailVo.setBatchName(prepayCardBatchEntity.getBatchName());
        prepayCardDetailVo.setCanSuspend(prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue());
        prepayCardDetailVo.setTransportType(this.promotionService.getPromotionDeliveryType(prepayCardBatchEntity.getProductPromotionId()));
        prepayCardDetailVo.setStatusName(PrepayCardStatusEnum.getName(prepayCardEntity.getStatus()));
        if (prepayCardEntity.getEndTime() != null && prepayCardEntity.getEndTime().before(DateUtils.now())) {
            prepayCardDetailVo.setStatus(PrepayCardStatusEnum.NOEFFECT.getValue());
        }
        prepayCardDetailVo.setStatusName(PrepayCardStatusEnum.getName(prepayCardDetailVo.getStatus()));
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        prepayCardDetailEntity.setCardId(cardId);
        List list = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
        Integer noDeliveryNum = 0;
        if (list.size() > 0) {
            list.sort(new Comparator<PrepayCardDetailEntity>(){

                @Override
                public int compare(PrepayCardDetailEntity o1, PrepayCardDetailEntity o2) {
                    return o1.getPickTime().compareTo(o2.getPickTime());
                }
            });
            ArrayList<PrepayCardPlanDetailVo> result = new ArrayList<PrepayCardPlanDetailVo>();
            String productName = "";
            int length = list.size();
            String[] weeks = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
            for (int j = 0; j < length; ++j) {
                PrepayCardPlanDetailVo prepayCardPlanDetailVo = new PrepayCardPlanDetailVo();
                prepayCardPlanDetailVo.setBox("\u7bb1");
                if (((PrepayCardDetailEntity)list.get(j)).getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue() || ((PrepayCardDetailEntity)list.get(j)).getStatus().intValue() == PrepayCardPlanStatusEnum.SUSPEND.getValue()) {
                    noDeliveryNum = noDeliveryNum + ((PrepayCardDetailEntity)list.get(j)).getQuantity();
                }
                if (((PrepayCardDetailEntity)list.get(j)).getStatus().intValue() == PrepayCardPlanStatusEnum.DELIVERY.getValue() && ((PrepayCardDetailEntity)list.get(j)).getPickTime().after(DateUtils.currentDate())) {
                    noDeliveryNum = noDeliveryNum + ((PrepayCardDetailEntity)list.get(j)).getQuantity();
                }
                BeanUtils.copyProperties(list.get(j), (Object)prepayCardPlanDetailVo);
                if (StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(j)).getOrderMainNo())) {
                    MallOrderEntity orderEntity = this.orderInterface.findOrders(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo()).get(0);
                    if (orderEntity != null) {
                        prepayCardPlanDetailVo.setConsigneePhone(orderEntity.getConsigneePhone());
                        prepayCardPlanDetailVo.setAddress(orderEntity.getConsigneeProvincename() + orderEntity.getConsigneeCityname() + orderEntity.getConsigneeAreaname() + orderEntity.getConsigneeAddr());
                        prepayCardPlanDetailVo.setConsigneeName(orderEntity.getConsigneeName());
                    }
                } else {
                    prepayCardPlanDetailVo.setConsigneeName("");
                }
                if (((PrepayCardDetailEntity)list.get(j)).getPickTime().after(DateUtils.now()) && ((PrepayCardDetailEntity)list.get(j)).getStatus().intValue() == PrepayCardPlanStatusEnum.DELIVERY.getValue()) {
                    ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
                }
                prepayCardPlanDetailVo.setStatusName(PrepayCardPlanStatusEnum.getName(((PrepayCardDetailEntity)list.get(j)).getStatus()));
                prepayCardPlanDetailVo.setNum(j + 1);
                prepayCardPlanDetailVo.setPickupDate(((PrepayCardDetailEntity)list.get(j)).getPickTime());
                prepayCardPlanDetailVo.setWeek(weeks[this.getLocalDate(((PrepayCardDetailEntity)list.get(j)).getPickTime()).getDayOfWeek().getValue() - 1]);
                if (StringUtils.isEmpty((String)productName)) {
                    MallPromotionEntity promotionEntity = this.promotionService.getPromotion(prepayCardBatchEntity.getProductPromotionId());
                    productName = promotionEntity == null ? "\u5976\u5361" : promotionEntity.getPromotionName();
                    prepayCardPlanDetailVo.setProductName(productName);
                }
                prepayCardPlanDetailVo.setProductName(productName);
                prepayCardPlanDetailVo.setStatus(((PrepayCardDetailEntity)list.get(j)).getStatus());
                if (StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(j)).getOrderMainNo())) {
                    prepayCardPlanDetailVo.setOrderNo(this.orderInterface.getOrderList(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo()).get(0).getOrderNo());
                } else {
                    prepayCardPlanDetailVo.setOrderNo("");
                }
                result.add(prepayCardPlanDetailVo);
            }
            prepayCardDetailVo.setPlanDetailList(result);
            prepayCardDetailVo.setCanSuspend(result.stream().anyMatch(d -> d.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue()));
            prepayCardDetailVo.setNoDeliveryNum(noDeliveryNum);
        } else {
            prepayCardDetailVo.setNoDeliveryNum(0);
        }
        Map<String, List<String>> pics = this.picService.getProductPicUrlMap(String.valueOf(prepayCardEntity.getBatchId()), SalesTypeEnum.SALES_PRODUCT.getValue());
        if (pics != null && pics.containsKey("picProductHead") && pics.get("picProductHead") != null && pics.get("picProductHead").size() > 0) {
            prepayCardDetailVo.setPic(pics.get("picProductHead").get(0));
        }
        return BaseJsonVo.success((Object)prepayCardDetailVo);
    }
}

