/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardDetailMapper;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanLogInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PrepayCardPlanDetailService
extends BaseService<PrepayCardDetailEntity, Integer>
implements PrepayCardPlanDetailInterface {
    @Resource
    PrepayCardDetailMapper prepayCardDetailMapper;
    @Autowired
    private PrepayCardPlanLogInterface planLogInterface;
    @Autowired
    private PrepayCardInterface prepayCardInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private MallRedisLock mallRedisLock;

    @Override
    @Transactional
    public BaseJsonVo suspendPrepayCardPlan(String carId) {
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        prepayCardDetailEntity.setCardId(carId);
        List list = this.prepayCardDetailMapper.getList(prepayCardDetailEntity);
        ArrayList result = new ArrayList();
        if (list.size() > 0) {
            list.forEach(d -> {
                if ((d.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue() || d.getStatus().intValue() == PrepayCardPlanStatusEnum.DELIVERY.getValue()) && d.getPickTime().after(DateUtils.currentDate())) {
                    PrepayCardDetailEntity update = new PrepayCardDetailEntity();
                    update.setDetailedId(d.getDetailedId());
                    update.setStatus(PrepayCardPlanStatusEnum.SUSPEND.getValue());
                    result.add(update);
                }
            });
        }
        return this.batchUpdate(result) > 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public int deletePrepayCardPlan(String carId, int status) {
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        prepayCardDetailEntity.setCardId(carId);
        prepayCardDetailEntity.setStatus(status);
        this.remoteCache(prepayCardDetailEntity);
        return this.prepayCardDetailMapper.deletePrepayCardPlan(carId, status);
    }

    private List<PrepayCardDetailEntity> getTodayValidPlan(Date today) {
        PrepayCardDetailEntity searchDetail = new PrepayCardDetailEntity();
        searchDetail.setStatus(2);
        Page page = PageHelper.startPage((int)1, (int)50);
        this.getList(searchDetail, 0L);
        List detailEntities = page.toPageInfo().getList();
        return detailEntities;
    }

    BaseJsonVo ValidatePlan(PrepayCardDetailEntity detailEntity) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)(detailEntity = (PrepayCardDetailEntity)this.selectByPrimaryKey(detailEntity.getDetailedId(), 0L)).getCardId()));
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u5e94\u7684\u5361\u4e0d\u5b58\u5728");
        }
        if (prepayCardEntity.getStatus() == null || prepayCardEntity.getStatus() != 2) {
            return BaseJsonVo.error((String)"\u5bf9\u5e94\u7684\u5361\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isEmpty((String)detailEntity.getCardOrderMainNo())) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u539f\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(detailEntity.getCardOrderMainNo());
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u539f\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (detailEntity.getPickTime() == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u6ca1\u6709\u9009\u62e9\u53d1\u8d27\u65e5\u671f");
        }
        if (detailEntity.getAddrId() == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u6ca1\u6709\u9009\u62e9\u6536\u8d27\u5730\u5740");
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo createPlanOrder(PrepayCardDetailEntity detailEntity, MallOrderCacheVo orderCacheVo) throws InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo baseJsonVo = this.ValidatePlan(detailEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        Object o = null;
        if (StringUtil.isEmpty((String)detailEntity.getOrderMainNo())) {
            orderCacheVo.setCacheType(2);
            orderCacheVo.setAddressId(detailEntity.getAddrId());
            orderCacheVo.setDeliverDate(detailEntity.getPickTime());
            orderCacheVo.setDeliverDate2(detailEntity.getPickTime());
            orderCacheVo.setSourceOrderNo(detailEntity.getCardOrderMainNo());
            baseJsonVo = this.tradeInterface.createOrder(PlatFormEnum.LECHUN_WECHAT_MAIN.getValue(), detailEntity.getCustomerId(), orderCacheVo);
            this.logger.info("createResult : " + JsonUtils.toJson((Object)baseJsonVo, (boolean)true));
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            o = baseJsonVo.getValue();
            this.updateOrderMainNo(detailEntity.getDetailedId(), o.toString());
        } else {
            o = detailEntity.getOrderMainNo();
        }
        String ip = "127.0.0.1";
        PayOutputEntity payOutputEntity = this.payOrderInterface.topay(detailEntity.getCustomerId(), o.toString(), ip);
        this.logger.info("payResult : " + JsonUtils.toJson((Object)payOutputEntity, (boolean)true));
        if (payOutputEntity.getStatus() != 6) {
            this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), payOutputEntity.getMessage());
            return BaseJsonVo.error((String)payOutputEntity.getMessage());
        }
        this.prepayCardPlanDetailInterface.orderPaySuccessUpdateCardPlanStatus(o.toString());
        this.planLogInterface.updateLogStatus(detailEntity.getDetailedId(), 1);
        return BaseJsonVo.success((Object)payOutputEntity);
    }

    @Override
    public BaseJsonVo createPlanOrder(Date today) {
        List<PrepayCardDetailEntity> detailEntities = this.getTodayValidPlan(today);
        for (PrepayCardDetailEntity detailEntity : detailEntities) {
            BaseJsonVo baseJsonVo = this.createPlanOrder(detailEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Async
    public BaseJsonVo createPlanOrder(String cardId) {
        PrepayCardDetailEntity search = new PrepayCardDetailEntity();
        search.setCardId(cardId);
        search.setStatus(2);
        List detailEntities = this.getList(search, 0L);
        for (PrepayCardDetailEntity detailEntity : detailEntities) {
            BaseJsonVo baseJsonVo = this.createPlanOrder(detailEntity);
            this.logger.info("\u521b\u5efa\u8ba2\u5355:{},\u53c2\u6570:{}", (Object)baseJsonVo.isSuccess(), (Object)detailEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createPlanOrder(PrepayCardDetailEntity detailEntity) {
        if (this.mallRedisLock.lock(detailEntity.getDetailedId() + ":createOrder", "1", 20L, TimeUnit.SECONDS)) {
            BaseJsonVo baseJsonVo = this.ValidatePlan(detailEntity);
            if (!baseJsonVo.isSuccess()) {
                this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), baseJsonVo.getMessage());
                return baseJsonVo;
            }
            baseJsonVo = this.setOrderCache(detailEntity);
            if (!baseJsonVo.isSuccess()) {
                this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), baseJsonVo.getMessage());
                return baseJsonVo;
            }
            try {
                baseJsonVo = this.createPlanOrder(detailEntity, (MallOrderCacheVo)baseJsonVo.getValue());
            }
            catch (InvalidKeySpecException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            if (!baseJsonVo.isSuccess()) {
                this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), baseJsonVo.getMessage());
                return baseJsonVo;
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo setOrderCache(PrepayCardDetailEntity detailEntity) {
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(1);
        inVo.setDeliverPeriod(1);
        inVo.setDeliverType(1);
        inVo.setOrderSource(detailEntity.getOrderSource());
        inVo.setBindCode("");
        inVo.setDefineField("");
        ArrayList<MallOrderCacheInItemVo> itemVoList = new ArrayList<MallOrderCacheInItemVo>();
        MallOrderCacheInItemVo itemVo = new MallOrderCacheInItemVo();
        itemVo.setItemId(detailEntity.getPromotionId());
        itemVo.setItemType(1);
        itemVo.setQuantity(detailEntity.getQuantity());
        itemVoList.add(itemVo);
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        return this.tradeInterface.setOrderCache(PlatFormEnum.LECHUN_WECHAT_MAIN.getValue(), detailEntity.getCustomerId(), inVo);
    }

    @Override
    @Transactional
    public BaseJsonVo orderPaySuccessUpdateCardPlanStatus(String orderMainNo) {
        PrepayCardDetailEntity entity = new PrepayCardDetailEntity();
        entity.setOrderMainNo(orderMainNo);
        entity = (PrepayCardDetailEntity)this.getSingle(entity, 0L);
        if (entity != null) {
            if (entity.getStatus() != 2) {
                return BaseJsonVo.error((String)"\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u66f4\u65b0");
            }
            entity.setStatus(4);
            if (this.updateByPrimaryKeySelective(entity) > 0) {
                return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
            }
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderConfirmGoodsUpdateCardPlanStatus(String orderMainNo) {
        try {
            PrepayCardDetailEntity entity = new PrepayCardDetailEntity();
            entity.setOrderMainNo(orderMainNo);
            entity = (PrepayCardDetailEntity)this.getSingle(entity);
            if (entity != null) {
                if (entity.getStatus() != 4) {
                    return BaseJsonVo.error((String)"\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u66f4\u65b0");
                }
                entity.setStatus(6);
                this.updateByPrimaryKeySelective(entity);
                PrepayCardDetailEntity search = new PrepayCardDetailEntity();
                search.setCardId(entity.getCardId());
                List lst = this.getList(search);
                if (lst.stream().filter(c -> c.getStatus() == 0 || c.getStatus() == 1 || c.getStatus() == 2 || c.getStatus() == 3 || c.getStatus() == 4).count() == 0L) {
                    this.prepayCardInterface.orderConfirmGoodsUpdateCardStatus(entity.getCardId());
                }
                return BaseJsonVo.success((Object)"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderRefundUpdateCardPlanStatus(String orderMainNo) {
        PrepayCardDetailEntity entity = new PrepayCardDetailEntity();
        entity.setOrderMainNo(orderMainNo);
        entity = (PrepayCardDetailEntity)this.getSingle(entity);
        if (entity != null) {
            if (entity.getStatus() == 5) {
                return BaseJsonVo.error((String)"\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u66f4\u65b0");
            }
            entity.setStatus(5);
            this.updateByPrimaryKeySelective(entity);
            PrepayCardDetailEntity search = new PrepayCardDetailEntity();
            search.setCardId(entity.getCardId());
            List lst = this.getList(search);
            if (lst.stream().filter(c -> c.getStatus() == 0 || c.getStatus() == 1 || c.getStatus() == 2 || c.getStatus() == 3 || c.getStatus() == 4 || c.getStatus() == 6).count() == 0L) {
                this.prepayCardInterface.orderRefundUpdateCardPlanStatus(entity.getCardId());
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    private BaseJsonVo updateOrderMainNo(Integer detailId, String orderMainNo) {
        PrepayCardDetailEntity detailEntity = new PrepayCardDetailEntity();
        detailEntity.setOrderMainNo(orderMainNo);
        PrepayCardDetailEntity search = new PrepayCardDetailEntity();
        search.setDetailedId(detailId);
        search.setStatus(2);
        if (this.updateByEntity(detailEntity, search) > 0) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5f02\u5e38");
    }

    @Override
    public BaseJsonVo editPlanOrder(PrepayCardDetailEntity cardDetailEntity) {
        BaseJsonVo baseJsonVo;
        List<Object> orderEntities = new ArrayList();
        if (cardDetailEntity.getStatus() != 4 && cardDetailEntity.getStatus() != 3) {
            return BaseJsonVo.success((Object)"\u8be5\u72b6\u6001\u65e0\u9700\u4fee\u6539\u8ba2\u5355");
        }
        if (StringUtil.isEmpty((String)cardDetailEntity.getOrderMainNo())) {
            return BaseJsonVo.success((Object)"\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff0c\u65e0\u9700\u4fee\u6539\u8ba2\u5355");
        }
        orderEntities = this.orderInterface.getOrderList(cardDetailEntity.getOrderMainNo());
        if (orderEntities == null || orderEntities.size() == 0) {
            return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u8be5\u8ba2\u5355");
        }
        if (cardDetailEntity.getStatus() == 4 && !(baseJsonVo = this.orderInterface.editOrderAddress(cardDetailEntity.getCustomerId(), ((MallOrderEntity)orderEntities.get(0)).getOrderNo(), cardDetailEntity.getAddrId())).isSuccess()) {
            return BaseJsonVo.error((String)("\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + baseJsonVo.getMessage() + "\uff1b"));
        }
        Date pickTime = DateUtils.StrToDate((String)DateUtils.formatDate((Date)cardDetailEntity.getPickTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
        if (cardDetailEntity.getStatus() == 3) {
            pickTime = DateUtils.StrToDate((String)"2038-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!(baseJsonVo = this.orderInterface.editOrderDeliverDate(cardDetailEntity.getCustomerId(), ((MallOrderEntity)orderEntities.get(0)).getOrderNo(), pickTime)).isSuccess()) {
            return BaseJsonVo.error((String)("\u8ba2\u5355\u914d\u9001\u65e5\u671f\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + baseJsonVo.getMessage() + "\uff1b"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deletePlanOrder(PrepayCardDetailEntity cardDetailEntity) {
        PrepayCardEntity cardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)cardDetailEntity.getCardId()));
        if (cardDetailEntity.getStatus() != 4 && cardDetailEntity.getStatus() != 3) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.success((Object)"\u8ba1\u5212\u8be5\u72b6\u6001\u4e0d\u80fd\u5220\u9664\u8ba2\u5355");
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(cardDetailEntity.getOrderMainNo());
        if (orderMainEntity == null) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)("\u8ba2\u5355\u4e0d\u5b58\u5728,\u8ba2\u5355\u53f7\uff1a" + cardDetailEntity.getOrderMainNo()));
        }
        try {
            BaseJsonVo<BalanceChangeDTO> baseJsonVo = this.tradeInterface.deletePrepayCardOrder(cardDetailEntity.getOrderMainNo());
            if (!baseJsonVo.isSuccess()) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return baseJsonVo;
            }
            BigDecimal orderAmount = orderMainEntity.getOrderAmount();
            this.logger.info("\u8c03\u7528\u4f59\u989d\u7cfb\u7edf\u8fd8\u652f\u4ed8\u91d1\u7684\u63a5\u53e3:cancelSpecialCardOrder,\u53c2\u6570cardNo:{},ordrMainNo:{},price:{},operater:{}", new Object[]{cardEntity.getRelateCardNo(), cardDetailEntity.getOrderMainNo(), orderAmount, cardDetailEntity.getCustomerId()});
            baseJsonVo = this.balanceAccountInvoke.cancelSpecialCardOrder(cardEntity.getRelateCardNo(), cardDetailEntity.getOrderMainNo(), orderAmount, cardDetailEntity.getCustomerId());
            this.logger.info("\u8c03\u7528\u4f59\u989d\u7cfb\u7edf\u8fd8\u652f\u4ed8\u91d1\u7684\u63a5\u53e3:cancelSpecialCardOrder,\u8fd4\u56de\uff1asuccess:{},message:{}", (Object)baseJsonVo.isSuccess(), (Object)baseJsonVo.getMessage());
            if (!baseJsonVo.isSuccess()) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return baseJsonVo;
            }
            PrepayCardEntity valueCard = new PrepayCardEntity();
            valueCard.setRemainCount(cardDetailEntity.getQuantity());
            valueCard.setUpdateTimeStamp(UUID.randomUUID().toString());
            PrepayCardEntity filterCard = new PrepayCardEntity();
            filterCard.setCardId(cardEntity.getCardId());
            filterCard.setUpdateTimeStamp(cardEntity.getUpdateTimeStamp());
            int count = this.prepayCardInterface.updatePlusByEntity(valueCard, filterCard);
            if (count == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u66f4\u65b0\u5976\u5361\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
            }
            count = this.deleteByPrimaryKey(cardDetailEntity.getDetailedId());
            if (count == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u5220\u9664\u5976\u5361\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
            }
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u5976\u5361\uff1a" + cardEntity.getCardId() + ",\u660e\u7ec6\uff1a" + cardDetailEntity.getDetailedId() + "\uff0c\u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
            return BaseJsonVo.error((String)"\u5220\u9664\u5976\u5361\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
        }
    }
}

